/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.accelerator.detector;

import com.builtbroken.atomic.api.accelerator.AcceleratorHelpers;
import com.builtbroken.atomic.api.accelerator.IAcceleratorNode;
import com.builtbroken.atomic.api.accelerator.IAcceleratorTube;
import com.builtbroken.atomic.content.machines.accelerator.data.TubeConnectionType;
import com.builtbroken.atomic.content.machines.accelerator.data.TubeSide;
import com.builtbroken.atomic.content.machines.accelerator.graph.AcceleratorNode;
import com.builtbroken.atomic.content.machines.accelerator.particle.AcceleratorParticle;
import com.builtbroken.atomic.content.prefab.TileEntityMachine;
import com.builtbroken.atomic.lib.timer.TickTimerConditional;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;

public class TileEntityParticleDetector
extends TileEntityMachine {
    public static final String NBT_TUBE_TYPE = "tube_type";
    public static final String NBT_SIDE_SETTINGS = "tube_settings";
    public static final String NBT_SIDE = "side";
    public static final String NBT_SPEED = "speed";
    protected final HashMap<TubeSide, Float> speedSettings = new HashMap();
    protected TubeConnectionType tubeConnectionType;
    protected IAcceleratorNode node;

    public TileEntityParticleDetector() {
        this.tickServer.add(TickTimerConditional.newTrigger(tick -> this.detectTube(), () -> this.node == null));
    }

    public void detectTube() {
        this.node = this.getNode((IBlockAccess)this.field_145850_b, EnumFacing.DOWN);
        if (this.node != null) {
            if (this.tubeConnectionType != this.node.getConnectionType()) {
                this.tubeConnectionType = this.node.getConnectionType();
                this.speedSettings.clear();
                this.tubeConnectionType.outputSides.forEach(side -> this.speedSettings.put((TubeSide)((Object)side), Float.valueOf(0.0f)));
            }
            if (this.node instanceof AcceleratorNode) {
                ((AcceleratorNode)this.node).turnController = (p, sides) -> this.getTurn((ImmutableList<TubeSide>)sides, (AcceleratorParticle)p);
            }
        }
    }

    public void detectLaser() {
    }

    private IAcceleratorNode getNode(IBlockAccess access, EnumFacing facing) {
        TileEntity tileEntity = access.func_175625_s(this.func_174877_v().func_177972_a(facing));
        IAcceleratorTube tube = AcceleratorHelpers.getAcceleratorTube(tileEntity, facing.func_176734_d());
        if (tube != null) {
            return tube.getNode();
        }
        return null;
    }

    public TubeSide getTurn(ImmutableList<TubeSide> possibleOutputs, AcceleratorParticle particle) {
        TubeSide out = null;
        float highestSpeedMatch = -1.0f;
        for (TubeSide side : possibleOutputs) {
            if (this.speedSettings.containsKey((Object)side)) {
                float speed = this.speedSettings.get((Object)side).floatValue();
                if (!(speed > highestSpeedMatch) || !(particle.getVelocity() >= speed)) continue;
                out = side;
                highestSpeedMatch = speed;
                continue;
            }
            if (out != null) continue;
            out = side;
        }
        return out;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b(NBT_TUBE_TYPE)) {
            this.tubeConnectionType = TubeConnectionType.byIndex(compound.func_74762_e(NBT_TUBE_TYPE));
        }
        if (compound.func_74764_b(NBT_SIDE_SETTINGS)) {
            this.speedSettings.clear();
            NBTTagList tubeSettingsSave = compound.func_150295_c(NBT_SIDE_SETTINGS, 10);
            for (int i = 0; i < tubeSettingsSave.func_74745_c(); ++i) {
                NBTTagCompound tubeData = tubeSettingsSave.func_150305_b(i);
                TubeSide side = TubeSide.byIndex(tubeData.func_74762_e(NBT_SIDE));
                float speed = tubeData.func_74760_g(NBT_SPEED);
                this.speedSettings.put(side, Float.valueOf(speed));
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (this.tubeConnectionType != null) {
            compound.func_74768_a(NBT_TUBE_TYPE, this.tubeConnectionType.ordinal());
        }
        if (!this.speedSettings.isEmpty()) {
            NBTTagList tubeSettingsSave = new NBTTagList();
            for (Map.Entry<TubeSide, Float> entry : this.speedSettings.entrySet()) {
                NBTTagCompound tubeData = new NBTTagCompound();
                tubeData.func_74768_a(NBT_SIDE, entry.getKey().ordinal());
                tubeData.func_74776_a(NBT_SPEED, entry.getValue().floatValue());
                tubeSettingsSave.func_74742_a((NBTBase)tubeData);
            }
            compound.func_74782_a(NBT_SIDE_SETTINGS, (NBTBase)tubeSettingsSave);
        }
        return super.func_189515_b(compound);
    }
}

