/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.accelerator.data;

import com.builtbroken.atomic.AtomicScience;
import net.minecraft.util.EnumFacing;

public enum TubeSide {
    FRONT,
    LEFT,
    RIGHT,
    BACK,
    CENTER;

    public static final TubeSide[] SIDES;

    public TubeSide getOpposite() {
        switch (this) {
            case FRONT: {
                return BACK;
            }
            case BACK: {
                return FRONT;
            }
            case LEFT: {
                return RIGHT;
            }
            case RIGHT: {
                return LEFT;
            }
        }
        return CENTER;
    }

    public static TubeSide byIndex(int index) {
        if (index >= 0 && index < TubeSide.values().length) {
            return TubeSide.values()[index];
        }
        return CENTER;
    }

    public EnumFacing getRotationRelative(EnumFacing centerFace, TubeSide targetSide) {
        EnumFacing sideFace = this.getFacing(centerFace);
        if (targetSide == FRONT || targetSide == BACK) {
            return targetSide.getFacing(sideFace.func_176734_d());
        }
        return targetSide.getFacing(sideFace);
    }

    public static TubeSide getSideFacingOut(EnumFacing facing, EnumFacing side) {
        if (side == null) {
            return CENTER;
        }
        if (side.func_176740_k() == EnumFacing.Axis.Y || facing.func_176740_k() == EnumFacing.Axis.Y) {
            if (AtomicScience.runningAsDev) {
                AtomicScience.logger.error("Something passed in the wrong side", (Throwable)new RuntimeException());
            }
            return CENTER;
        }
        if (side == facing) {
            return FRONT;
        }
        if (side == facing.func_176734_d()) {
            return BACK;
        }
        if (facing.func_176746_e().func_176734_d() == side) {
            return LEFT;
        }
        if (facing.func_176746_e() == side) {
            return RIGHT;
        }
        return CENTER;
    }

    public EnumFacing getFacing(EnumFacing facing) {
        if (facing == null) {
            return null;
        }
        if (this == FRONT) {
            return facing;
        }
        if (this == LEFT) {
            return facing.func_176746_e().func_176734_d();
        }
        if (this == RIGHT) {
            return facing.func_176746_e();
        }
        if (this == BACK) {
            return facing.func_176734_d();
        }
        return null;
    }

    static {
        SIDES = new TubeSide[]{FRONT, LEFT, RIGHT, BACK};
    }
}

