/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.accelerator.data;

import com.builtbroken.atomic.content.machines.accelerator.data.TubeSide;
import com.builtbroken.atomic.content.machines.accelerator.data.TubeSideType;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import net.minecraft.util.IStringSerializable;

public enum TubeConnectionType implements IStringSerializable
{
    NORMAL(TubeSideType.EXIT, TubeSideType.NONE, TubeSideType.NONE, TubeSideType.ENTER),
    CORNER_RIGHT(TubeSideType.EXIT, TubeSideType.NONE, TubeSideType.ENTER, TubeSideType.NONE),
    CORNER_LEFT(TubeSideType.EXIT, TubeSideType.ENTER, TubeSideType.NONE, TubeSideType.NONE),
    T_JOIN_RIGHT(TubeSideType.EXIT, TubeSideType.NONE, TubeSideType.ENTER, TubeSideType.ENTER),
    T_JOIN_LEFT(TubeSideType.EXIT, TubeSideType.ENTER, TubeSideType.NONE, TubeSideType.ENTER),
    T_JOIN(TubeSideType.EXIT, TubeSideType.ENTER, TubeSideType.ENTER, TubeSideType.NONE),
    JOIN(TubeSideType.EXIT, TubeSideType.ENTER, TubeSideType.ENTER, TubeSideType.ENTER),
    T_SPLIT(TubeSideType.NONE, TubeSideType.EXIT, TubeSideType.EXIT, TubeSideType.ENTER),
    T_SPLIT_RIGHT(TubeSideType.EXIT, TubeSideType.NONE, TubeSideType.EXIT, TubeSideType.ENTER),
    T_SPLIT_LEFT(TubeSideType.EXIT, TubeSideType.EXIT, TubeSideType.NONE, TubeSideType.ENTER),
    SPLIT(TubeSideType.EXIT, TubeSideType.EXIT, TubeSideType.EXIT, TubeSideType.ENTER),
    START_CAP(false, TubeSideType.EXIT, TubeSideType.NONE, TubeSideType.NONE, TubeSideType.NONE),
    END_CAP(false, TubeSideType.NONE, TubeSideType.NONE, TubeSideType.NONE, TubeSideType.ENTER),
    INVALID(false, TubeSideType.NONE, TubeSideType.NONE, TubeSideType.NONE, TubeSideType.NONE);

    public final TubeSideType[] connections;
    public final ImmutableList<TubeSide> outputSides;
    public final ImmutableList<TubeSide> inputSides;
    public final boolean canUserPlace;
    public static TubeConnectionType[] VALID;

    private TubeConnectionType(TubeSideType front, TubeSideType left, TubeSideType right, TubeSideType back) {
        this(true, front, left, right, back);
    }

    private TubeConnectionType(boolean canPlace, TubeSideType front, TubeSideType left, TubeSideType right, TubeSideType back) {
        this.canUserPlace = canPlace;
        this.connections = new TubeSideType[]{front, left, right, back};
        ArrayList<TubeSide> enterList = new ArrayList<TubeSide>();
        ArrayList<TubeSide> exitList = new ArrayList<TubeSide>();
        for (TubeSide side : TubeSide.SIDES) {
            TubeSideType type = this.connections[side.ordinal()];
            if (type == TubeSideType.ENTER) {
                enterList.add(side);
                continue;
            }
            if (type != TubeSideType.EXIT) continue;
            exitList.add(side);
        }
        this.outputSides = ImmutableList.copyOf(exitList);
        this.inputSides = ImmutableList.copyOf(enterList);
    }

    public static TubeConnectionType byIndex(int i) {
        if (i >= 0 && i < TubeConnectionType.values().length) {
            return TubeConnectionType.values()[i];
        }
        return NORMAL;
    }

    public TubeSideType getTypeForSide(TubeSide side) {
        if (side != null && side != TubeSide.CENTER) {
            return this.connections[side.ordinal()];
        }
        return TubeSideType.NONE;
    }

    public TubeSideType front() {
        return this.connections[TubeSide.FRONT.ordinal()];
    }

    public TubeSideType left() {
        return this.connections[TubeSide.LEFT.ordinal()];
    }

    public TubeSideType right() {
        return this.connections[TubeSide.RIGHT.ordinal()];
    }

    public TubeSideType back() {
        return this.connections[TubeSide.BACK.ordinal()];
    }

    public boolean connectionsMatch(TubeSideType front, TubeSideType left, TubeSideType right, TubeSideType back) {
        return this.front() == front && this.back() == back && this.left() == left && this.right() == right;
    }

    public static TubeConnectionType getTypeForLayout(TubeSideType front, TubeSideType left, TubeSideType right, TubeSideType back, boolean canPlaceOnly) {
        for (TubeConnectionType type : TubeConnectionType.values()) {
            if (!type.connectionsMatch(front, left, right, back) || !type.canUserPlace && canPlaceOnly) continue;
            return type;
        }
        return INVALID;
    }

    public String func_176610_l() {
        return this.name().toLowerCase();
    }

    static {
        VALID = new TubeConnectionType[]{NORMAL, CORNER_RIGHT, CORNER_LEFT, T_JOIN_RIGHT, T_JOIN_LEFT, T_JOIN, JOIN, T_SPLIT, T_SPLIT_RIGHT, T_SPLIT_LEFT, SPLIT};
    }
}

