/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines;

import com.builtbroken.atomic.config.content.ConfigContent;
import com.builtbroken.atomic.content.machines.TileEntityInventoryMachine;
import com.builtbroken.atomic.lib.power.Battery;
import com.builtbroken.atomic.lib.power.PowerSystem;
import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class TileEntityPowerInvMachine<I extends IItemHandlerModifiable>
extends TileEntityInventoryMachine<I> {
    public static final String NBT_ENERGY = "energy";
    private Battery energyStorage;

    public abstract int getEnergyUsage();

    public Battery getEnergyStorage() {
        if (this.energyStorage == null) {
            this.energyStorage = this.createEnergyStorage();
        }
        return this.energyStorage;
    }

    protected Battery createEnergyStorage() {
        return new Battery(this.getMaxEnergyStored()){

            @Override
            protected void onEnergyChanged(int prev, int current) {
                TileEntityPowerInvMachine.this.syncClientNextTick();
            }
        };
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return ConfigContent.POWER_USAGE.ENABLE;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && ConfigContent.POWER_USAGE.ENABLE) {
            return (T)this.getEnergyStorage();
        }
        return super.getCapability(capability, facing);
    }

    protected boolean checkEnergyExtract() {
        return !ConfigContent.POWER_USAGE.ENABLE || this.getEnergyStored() >= this.getEnergyUsage();
    }

    protected void extractEnergy() {
        if (ConfigContent.POWER_USAGE.ENABLE) {
            this.getEnergyStorage().extractEnergy(this.getEnergyUsage(), false);
        }
    }

    public int getEnergyStored() {
        return !ConfigContent.POWER_USAGE.ENABLE ? this.getMaxEnergyStored() : this.getEnergyStorage().getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.getEnergyUsage() * 10;
    }

    protected void drainBattery(int slot) {
        ItemStack itemStack;
        int power;
        if (ConfigContent.POWER_USAGE.ENABLE && (power = PowerSystem.getEnergyStored(itemStack = this.getInventory().getStackInSlot(slot))) > 0) {
            power = PowerSystem.dischargeItem(itemStack, power, false);
            int added = this.getEnergyStorage().receiveEnergy(power, false);
            PowerSystem.dischargeItem(itemStack, added, true);
            this.getInventory().setStackInSlot(slot, itemStack);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.getEnergyStorage().setEnergy(nbt.func_74762_e(NBT_ENERGY));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74768_a(NBT_ENERGY, this.getEnergyStorage().getEnergyStored());
        return super.func_189515_b(nbt);
    }

    @Override
    protected void writeDescPacket(List<Object> dataList, EntityPlayer player) {
        dataList.add(this.getEnergyStored());
    }

    @Override
    protected void readDescPacket(ByteBuf buf, EntityPlayer player) {
        this.getEnergyStorage().setEnergy(buf.readInt());
    }

    @Override
    protected void writeGuiPacket(List<Object> dataList, EntityPlayer player) {
        dataList.add(this.getEnergyStored());
    }

    @Override
    protected void readGuiPacket(ByteBuf buf, EntityPlayer player) {
        this.getEnergyStorage().setEnergy(buf.readInt());
    }
}

