/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines;

import com.builtbroken.atomic.content.prefab.TileEntityMachine;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TileEntityInventoryMachine<I extends IItemHandlerModifiable>
extends TileEntityMachine {
    public static final String NBT_INVENTORY = "inventory";
    private IItemHandlerModifiable inventory;
    private I inventoryWrapper;

    public IItemHandlerModifiable getInventory() {
        if (this.inventory == null) {
            this.inventory = this.createInternalInventory();
        }
        return this.inventory;
    }

    protected IItemHandlerModifiable createInternalInventory() {
        return new ItemStackHandler(this.inventorySize());
    }

    @Nonnull
    protected abstract I createInventory();

    protected abstract int inventorySize();

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.canInventoryConnect(facing);
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.inventoryWrapper == null) {
                this.inventoryWrapper = this.createInventory();
            }
            return (T)this.inventoryWrapper;
        }
        return (T)super.getCapability(capability, facing);
    }

    protected boolean canInventoryConnect(EnumFacing side) {
        return true;
    }

    @Deprecated
    protected void onSlotStackChanged(ItemStack prev, ItemStack stack, int slot) {
        this.func_70296_d();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        for (int slotIndex = 0; slotIndex < this.getInventory().getSlots(); ++slotIndex) {
            this.getInventory().setStackInSlot(slotIndex, ItemStack.field_190927_a);
        }
        NBTTagList nbttaglist = nbt.func_150295_c(NBT_INVENTORY, 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound save = nbttaglist.func_150305_b(i);
            int slotIndex = save.func_74771_c("Slot") & 0xFF;
            if (slotIndex < 0 || slotIndex >= this.getInventory().getSlots()) continue;
            this.getInventory().setStackInSlot(slotIndex, new ItemStack(save));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int slotIndex = 0; slotIndex < this.getInventory().getSlots(); ++slotIndex) {
            ItemStack stack = this.getInventory().getStackInSlot(slotIndex);
            if (stack.func_190926_b()) continue;
            NBTTagCompound save = new NBTTagCompound();
            save.func_74774_a("Slot", (byte)slotIndex);
            stack.func_77955_b(save);
            nbttaglist.func_74742_a((NBTBase)save);
        }
        nbt.func_74782_a(NBT_INVENTORY, (NBTBase)nbttaglist);
        return super.func_189515_b(nbt);
    }
}

