/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.items.wrench;

import java.awt.Color;

public enum WrenchColor {
    GREEN(Color.GREEN),
    YELLOW(Color.YELLOW),
    RED(Color.RED),
    BLUE(Color.BLUE),
    PURPLE(Color.MAGENTA),
    ORANGE(Color.ORANGE);

    final Color color;

    private WrenchColor(Color color) {
        this.color = color;
    }

    public static WrenchColor get(int value) {
        if (value >= 0 && value < WrenchColor.values().length) {
            return WrenchColor.values()[value];
        }
        return RED;
    }

    public int getColorInt() {
        return this.color.getRGB();
    }

    public WrenchColor next() {
        int i = this.ordinal() + 1;
        if (i >= WrenchColor.values().length) {
            i = 0;
        }
        return WrenchColor.values()[i];
    }

    public WrenchColor prev() {
        int i = this.ordinal() - 1;
        if (i < 0) {
            i = WrenchColor.values().length - 1;
        }
        return WrenchColor.values()[i];
    }

    public Color getColor() {
        return this.color;
    }
}

