/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.items.wrench;

import com.builtbroken.atomic.content.items.wrench.WrenchColor;
import com.builtbroken.atomic.content.items.wrench.WrenchMode;
import com.builtbroken.atomic.content.machines.processing.TileEntityProcessingMachine;
import com.builtbroken.atomic.content.prefab.ItemPrefab;
import com.builtbroken.atomic.lib.LanguageUtility;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWrench
extends ItemPrefab {
    public static final String NBT_COLOR = "toolColor";
    public static final String NBT_MODE = "toolMode";

    public ItemWrench() {
        super("wrench", "wrench");
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityProcessingMachine) {
            if (!world.field_72995_K) {
                ItemStack stack = player.func_184586_b(hand);
                ((TileEntityProcessingMachine)tile).onWrench(this.getMode(stack), this.getColor(stack), side, player);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public void handleMouseWheelAction(ItemStack stack, EntityPlayer player, boolean ctrl, boolean forward) {
        if (ctrl) {
            this.toggleMode(stack, forward);
        } else {
            this.toggleColor(stack, forward);
        }
        player.field_71069_bz.func_75142_b();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> lines, ITooltipFlag flagIn) {
        lines.add(LanguageUtility.getLocal(this.func_77658_a() + ".mode." + this.getMode(stack).name().toLowerCase() + ".info"));
        lines.add(LanguageUtility.getLocal(this.func_77658_a() + ".color." + this.getColor(stack).name().toLowerCase() + ".info"));
        if (GuiScreen.func_146272_n()) {
            lines.add(LanguageUtility.getLocal(this.func_77658_a() + ".info"));
            lines.add(LanguageUtility.getLocal(this.func_77658_a() + ".use.info"));
            lines.add(LanguageUtility.getLocal(this.func_77658_a() + ".ctrl.info"));
            lines.add(LanguageUtility.getLocal(this.func_77658_a() + ".wheel.info"));
        } else {
            lines.add(LanguageUtility.getLocal(this.func_77658_a() + ".more.info"));
        }
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + "." + this.getMode(stack).name().toLowerCase() + "." + this.getColor(stack).name().toLowerCase();
    }

    public void toggleMode(ItemStack stack, boolean forward) {
        this.setMode(stack, forward ? this.getMode(stack).next() : this.getMode(stack).prev());
    }

    public WrenchMode getMode(ItemStack stack) {
        if (stack.func_77978_p() != null) {
            return WrenchMode.get(stack.func_77978_p().func_74762_e(NBT_MODE));
        }
        return WrenchMode.ROTATION;
    }

    public void setMode(ItemStack stack, WrenchMode mode) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a(NBT_MODE, mode.ordinal());
    }

    public void toggleColor(ItemStack stack, boolean forward) {
        this.setColor(stack, forward ? this.getColor(stack).next() : this.getColor(stack).prev());
    }

    public WrenchColor getColor(ItemStack stack) {
        if (stack.func_77978_p() != null) {
            return WrenchColor.get(stack.func_77978_p().func_74762_e(NBT_COLOR));
        }
        return WrenchColor.RED;
    }

    public void setColor(ItemStack stack, WrenchColor color) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a(NBT_COLOR, color.ordinal());
    }
}

