/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.items.cell;

import com.builtbroken.atomic.content.ASItems;
import com.builtbroken.atomic.content.items.cell.ItemFluidCell;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class ModelFluidBucket
implements IModel {
    public static final ResourceLocation fluid_mask_texture = new ResourceLocation("atomicscience", "items/cell_fluid_mask");
    public static final ResourceLocation base_texture = new ResourceLocation("atomicscience", "items/cell_empty");
    private static final float NORTH_Z_FLUID = 0.468625f;
    private static final float SOUTH_Z_FLUID = 0.531375f;
    public static final IModel MODEL = new ModelFluidBucket();
    protected final Fluid fluid;
    protected final Item item;
    private static final TRSRTransformation flipX = new TRSRTransformation(null, null, new Vector3f(-1.0f, 1.0f, 1.0f), null);

    public ModelFluidBucket() {
        this(null, null);
    }

    public ModelFluidBucket(Fluid fluid, Item item) {
        this.fluid = fluid;
        this.item = item;
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of();
    }

    public Collection<ResourceLocation> getTextures() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)fluid_mask_texture);
        builder.add((Object)base_texture);
        builder.addAll(ASItems.itemFluidCell.supportedFluidToTexturePath.values());
        builder.addAll(ASItems.itemPoweredCell.supportedFluidToTexturePath.values());
        return builder.build();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, java.util.function.Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((IModelState)state);
        if (transformMap.isEmpty()) {
            TRSRTransformation thirdperson = ModelFluidBucket.get(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f);
            TRSRTransformation firstperson = ModelFluidBucket.get(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)ModelFluidBucket.get(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
            builder.put((Object)ItemCameraTransforms.TransformType.HEAD, (Object)ModelFluidBucket.get(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f));
            builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)thirdperson);
            builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)ModelFluidBucket.leftify(thirdperson));
            builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)firstperson);
            builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)ModelFluidBucket.leftify(firstperson));
            transformMap = PerspectiveMapWrapper.getTransforms((IModelState)new SimpleModelState(builder.build()));
        }
        if (this.fluid != null && this.fluid.isGaseous()) {
            state = new ModelStateComposition(state, (IModelState)TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(null, new Quat4f(0.0f, 0.0f, 1.0f, 0.0f), null, null)));
        }
        TRSRTransformation transform = state.apply(Optional.empty()).orElse(TRSRTransformation.identity());
        ImmutableList.Builder builder = ImmutableList.builder();
        TextureAtlasSprite fluidSprite = null;
        if (this.fluid != null) {
            if (this.item instanceof ItemFluidCell && ((ItemFluidCell)this.item).supportedFluidToTexturePath.containsKey(this.fluid)) {
                ResourceLocation texture = ((ItemFluidCell)this.item).supportedFluidToTexturePath.get(this.fluid);
                fluidSprite = bakedTextureGetter.apply(texture);
                IBakedModel modelFluid = new ItemLayerModel(ImmutableList.of((Object)texture)).bake(state, format, bakedTextureGetter);
                builder.addAll((Iterable)modelFluid.func_188616_a(null, null, 0L));
            } else {
                IBakedModel modelCell = new ItemLayerModel(ImmutableList.of((Object)base_texture)).bake(state, format, bakedTextureGetter);
                builder.addAll((Iterable)modelCell.func_188616_a(null, null, 0L));
                fluidSprite = bakedTextureGetter.apply(this.fluid.getStill());
                if (fluidSprite != null) {
                    TextureAtlasSprite liquid = bakedTextureGetter.apply(fluid_mask_texture);
                    builder.addAll((Iterable)ItemTextureQuadConverter.convertTexture((VertexFormat)format, (TRSRTransformation)transform, (TextureAtlasSprite)liquid, (TextureAtlasSprite)fluidSprite, (float)0.468625f, (EnumFacing)EnumFacing.NORTH, (int)this.fluid.getColor()));
                    builder.addAll((Iterable)ItemTextureQuadConverter.convertTexture((VertexFormat)format, (TRSRTransformation)transform, (TextureAtlasSprite)liquid, (TextureAtlasSprite)fluidSprite, (float)0.531375f, (EnumFacing)EnumFacing.SOUTH, (int)this.fluid.getColor()));
                }
            }
        } else {
            IBakedModel modelCell = new ItemLayerModel(ImmutableList.of((Object)base_texture)).bake(state, format, bakedTextureGetter);
            builder.addAll((Iterable)modelCell.func_188616_a(null, null, 0L));
        }
        return new BakedFluidBucket(this, (ImmutableList<BakedQuad>)builder.build(), fluidSprite, format, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)Maps.immutableEnumMap((Map)transformMap), Maps.newHashMap());
    }

    private static TRSRTransformation get(float tx, float ty, float tz, float ax, float ay, float az, float s) {
        return TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(ax, ay, az)), new Vector3f(s, s, s), null));
    }

    private static TRSRTransformation leftify(TRSRTransformation transform) {
        return TRSRTransformation.blockCenterToCorner((TRSRTransformation)flipX.compose(TRSRTransformation.blockCornerToCenter((TRSRTransformation)transform)).compose(flipX));
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public IModel process(ImmutableMap<String, String> customData) {
        String fluidName = (String)customData.get((Object)"fluid");
        Fluid fluid = FluidRegistry.getFluid((String)fluidName);
        if (fluid == null) {
            fluid = this.fluid;
        }
        String itemName = (String)customData.get((Object)"item");
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(itemName));
        return new ModelFluidBucket(fluid, item);
    }

    private static final class BakedFluidBucket
    implements IBakedModel {
        private final ModelFluidBucket parent;
        private final Map<String, IBakedModel> cache;
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        private final ImmutableList<BakedQuad> quads;
        private final TextureAtlasSprite particle;
        private final VertexFormat format;

        public BakedFluidBucket(ModelFluidBucket parent, ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, VertexFormat format, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, Map<String, IBakedModel> cache) {
            this.quads = quads;
            this.particle = particle;
            this.format = format;
            this.parent = parent;
            this.transforms = transforms;
            this.cache = cache;
        }

        public ItemOverrideList func_188617_f() {
            return BakedDynBucketOverrideHandler.INSTANCE;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)cameraTransformType);
        }

        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            if (side == null) {
                return this.quads;
            }
            return ImmutableList.of();
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.particle;
        }
    }

    private static final class BakedDynBucketOverrideHandler
    extends ItemOverrideList {
        public static final BakedDynBucketOverrideHandler INSTANCE = new BakedDynBucketOverrideHandler();

        private BakedDynBucketOverrideHandler() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            FluidStack fluidStack;
            BakedFluidBucket model = (BakedFluidBucket)originalModel;
            String fluidName = "";
            if (stack.func_77973_b() instanceof ItemFluidCell && (fluidStack = ((ItemFluidCell)stack.func_77973_b()).getFluid(stack)) != null && fluidStack.getFluid() != null) {
                fluidName = fluidStack.getFluid().getName();
            }
            String key = fluidName;
            if (!model.cache.containsKey(key)) {
                IModel parent = model.parent.process((ImmutableMap<String, String>)ImmutableMap.of((Object)"fluid", (Object)fluidName, (Object)"item", (Object)stack.func_77973_b().getRegistryName().toString()));
                Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

                    public TextureAtlasSprite apply(ResourceLocation location) {
                        return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                    }
                };
                IBakedModel bakedModel = parent.bake((IModelState)new SimpleModelState(model.transforms), model.format, (java.util.function.Function)textureGetter);
                model.cache.put(key, bakedModel);
                return bakedModel;
            }
            return (IBakedModel)model.cache.get(key);
        }
    }
}

