/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.items.cell;

import com.builtbroken.atomic.AtomicScience;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFluidCell
extends Item {
    public HashMap<Fluid, ResourceLocation> supportedFluidToTexturePath = new HashMap();
    public HashMap<Fluid, String> supportedFluidToLocalization = new HashMap();
    public final int fluidCapacity;

    public ItemFluidCell(int fluidCapacity) {
        this.fluidCapacity = fluidCapacity;
        this.func_77655_b("atomicscience:cell.fluid");
        this.func_77637_a(AtomicScience.creativeTab);
    }

    public void addSupportedFluid(Fluid fluid, String texture, String name) {
        this.supportedFluidToTexturePath.put(fluid, new ResourceLocation(texture));
        this.supportedFluidToLocalization.put(fluid, name);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new FluidHandlerItemStack(stack, this.fluidCapacity){

            public boolean canFillFluidType(FluidStack fluid) {
                return ItemFluidCell.this.canSupportFluid(this.container, fluid);
            }
        };
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> lines, ITooltipFlag flagIn) {
        FluidStack fluidStack = this.getFluid(stack);
        if (fluidStack != null) {
            lines.add("Fluid: " + fluidStack.getLocalizedName());
            lines.add("Amount: " + fluidStack.amount);
        }
    }

    public String func_77667_c(ItemStack stack) {
        FluidStack fluidStack = this.getFluid(stack);
        if (fluidStack != null && this.supportedFluidToLocalization.containsKey(fluidStack.getFluid())) {
            return this.supportedFluidToLocalization.get(fluidStack.getFluid());
        }
        return super.func_77658_a();
    }

    public int getItemStackLimit(ItemStack stack) {
        return !this.hasContainerItem(stack) ? Items.field_151133_ar.getItemStackLimit(stack) : 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        super.func_150895_a(tab, list);
        if (tab == this.func_77640_w()) {
            for (Fluid fluid : this.supportedFluidToTexturePath.keySet()) {
                list.add((Object)this.getContainerForFluid(fluid));
            }
        }
    }

    public ItemStack getContainerForFluid(Fluid fluid) {
        ItemStack stack = new ItemStack((Item)this);
        IFluidHandlerItem handlerItem = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (handlerItem != null) {
            handlerItem.fill(new FluidStack(fluid, handlerItem.getTankProperties()[0].getCapacity()), true);
            return handlerItem.getContainer();
        }
        return stack;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return this.getFluid(stack) != null;
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        if (!this.hasContainerItem(itemStack)) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack((Item)this);
    }

    public FluidStack getFluid(ItemStack stack) {
        IFluidHandlerItem handlerItem = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (handlerItem != null) {
            return handlerItem.drain(Integer.MAX_VALUE, false);
        }
        return null;
    }

    public boolean canSupportFluid(ItemStack container, FluidStack resource) {
        return resource != null;
    }
}

