/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.items;

import com.builtbroken.atomic.api.item.IFuelRodItem;
import com.builtbroken.atomic.api.reactor.IReactor;
import com.builtbroken.atomic.content.items.ItemRadioactive;
import com.builtbroken.atomic.lib.LanguageUtility;
import java.util.List;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFuelRod
extends ItemRadioactive
implements IFuelRodItem {
    public static final String NBT_FUEL_TIME = "fuelTimer";
    public final IntSupplier maxFuelRuntime;
    public final IntSupplier reactorRadioactivity;
    public final IntSupplier reactorHeatOutput;

    public ItemFuelRod(String key, String name, IntSupplier maxFuelRuntime, IntSupplier radioactiveMaterialValue, IntSupplier reactorRadioactivity, IntSupplier reactorHeatOutput) {
        super(key, name, radioactiveMaterialValue);
        this.maxFuelRuntime = maxFuelRuntime;
        this.reactorRadioactivity = reactorRadioactivity;
        this.reactorHeatOutput = reactorHeatOutput;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> lines, ITooltipFlag flagIn) {
        int time = this.getFuelRodRuntime(stack, null);
        int maxTime = this.getMaxFuelRodRuntime(stack, null);
        String translation = LanguageUtility.getLocal(this.func_77658_a() + ".info.fuel");
        translation = translation.replace("-time-", "" + time);
        translation = translation.replace("-maxTime-", "" + maxTime);
        lines.add(translation);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return Math.min(1.0, Math.max(0.0, 1.0 - (double)this.getFuelRodRuntime(stack, null) / (double)this.getMaxFuelRodRuntime(stack, null)));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getFuelRodRuntime(stack, null) != this.getMaxFuelRodRuntime(stack, null);
    }

    @Override
    public int getFuelRodRuntime(ItemStack stack, IReactor reactor) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74768_a(NBT_FUEL_TIME, this.getMaxFuelRodRuntime(stack, reactor));
        }
        return stack.func_77978_p().func_74762_e(NBT_FUEL_TIME);
    }

    @Override
    public int getMaxFuelRodRuntime(ItemStack stack, IReactor reactor) {
        return this.maxFuelRuntime.getAsInt();
    }

    @Override
    public int getHeatOutput(ItemStack stack, IReactor reactor) {
        return this.reactorHeatOutput.getAsInt();
    }

    @Override
    public int getRadioactiveMaterial(ItemStack stack, IReactor reactor) {
        return this.reactorRadioactivity.getAsInt();
    }

    @Override
    public ItemStack onReactorTick(IReactor reactor, ItemStack stack, int tick, int fuelTick) {
        this.setFuelTime(stack, Math.max(0, fuelTick - 1));
        return stack;
    }

    public ItemStack setFuelTime(ItemStack stack, int time) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a(NBT_FUEL_TIME, time);
        return stack;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this));
            items.add((Object)this.setFuelTime(new ItemStack((Item)this), 0));
        }
    }
}

