/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.effects.client;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.client.ClientProxy;
import com.builtbroken.atomic.config.client.ConfigClient;
import com.builtbroken.atomic.config.logic.ConfigRadiation;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class RenderRadOverlay {
    public static final Color startColor = new Color(8453920);
    public static final Color endColor = new Color(16726283);
    public static final RenderRadOverlay INSTANCE = new RenderRadOverlay();

    @SubscribeEvent
    public void renderOverlay(RenderGameOverlayEvent.Post event) {
        if (ConfigClient.RADIATION_DISPLAY.ENABLE && !Minecraft.func_71410_x().field_71474_y.field_74330_P && !Minecraft.func_71410_x().func_189648_am()) {
            int width = event.getResolution().func_78326_a();
            int height = event.getResolution().func_78328_b();
            Minecraft mc = Minecraft.func_71410_x();
            if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
                GL11.glPushMatrix();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int left = 5;
                int top = 5;
                float rad_player = this.interpolate(ClientProxy.PREV_RAD_PLAYER, ClientProxy.RAD_PLAYER, event.getPartialTicks());
                float rad_area = this.interpolate(ClientProxy.PREV_RAD_EXPOSURE, ClientProxy.RAD_EXPOSURE, event.getPartialTicks());
                float rad_dead_min = ConfigRadiation.RADIATION_DEATH_POINT / 1200.0f;
                String remDisplay = this.formatDisplay("PER:", rad_player, "rem");
                String radDisplay = this.formatDisplay("ENV: ", rad_area * 20.0f, "rem/s");
                RenderRadOverlay.renderTextWithShadow(remDisplay, left, top, this.interpolate(startColor, endColor, rad_player / ConfigRadiation.RADIATION_DEATH_POINT).getRGB());
                RenderRadOverlay.renderTextWithShadow(radDisplay, left, top + 10, this.interpolate(startColor, endColor, rad_area / rad_dead_min).getRGB());
                if (AtomicScience.runningAsDev) {
                    RenderRadOverlay.renderTextWithShadow("" + ClientProxy.RAD_REMOVE_TIMER, left, top + 20, endColor.getRGB());
                }
                ClientProxy.PREV_RAD_PLAYER = rad_player;
                ClientProxy.PREV_RAD_EXPOSURE = rad_area;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
            }
        }
    }

    public static void renderTextWithShadow(String text, int x, int y, int colorRGB) {
        GL11.glPushMatrix();
        FontRenderer fontrenderer = Minecraft.func_71410_x().field_71466_p;
        fontrenderer.func_78276_b(text, x + 1, y, 0);
        fontrenderer.func_78276_b(text, x - 1, y, 0);
        fontrenderer.func_78276_b(text, x, y + 1, 0);
        fontrenderer.func_78276_b(text, x, y - 1, 0);
        fontrenderer.func_78276_b(text, x, y, colorRGB);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    protected Color interpolate(Color color, Color color2, float per) {
        per = Math.max(0.0f, Math.min(1.0f, per));
        float r = this.interpolate((float)color.getRed() / 255.0f, (float)color2.getRed() / 255.0f, per);
        float g = this.interpolate((float)color.getGreen() / 255.0f, (float)color2.getGreen() / 255.0f, per);
        float b = this.interpolate((float)color.getBlue() / 255.0f, (float)color2.getBlue() / 255.0f, per);
        return new Color(r, g, b);
    }

    private float interpolate(float a, float b, float proportion) {
        if (Float.isNaN(a)) {
            return Float.isNaN(b) ? 0.0f : b;
        }
        if (Float.isNaN(b)) {
            return Float.isNaN(a) ? 0.0f : a;
        }
        return a + (b - a) * proportion;
    }

    protected String formatDisplay(String prefix, float number, String sufix) {
        return String.format("%s %6s%s", prefix, String.format("%.2f", Float.valueOf(number)), sufix);
    }
}

