/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.effects;

import com.builtbroken.atomic.api.AtomicScienceAPI;
import com.builtbroken.atomic.config.logic.ConfigRadiation;
import com.builtbroken.atomic.content.ASIndirectEffects;
import com.builtbroken.atomic.content.effects.effects.REOPotion;
import com.builtbroken.atomic.content.effects.effects.RadiationEffectOutcome;
import com.builtbroken.atomic.content.effects.source.SourceWrapperPosition;
import com.builtbroken.atomic.map.MapHandler;
import com.builtbroken.atomic.network.netty.PacketSystem;
import com.builtbroken.atomic.network.packet.sync.PacketPlayerRadiation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RadiationEntityEventHandler {
    public static DamageSource radiationDeathDamage = new DamageSource("radiation").func_76348_h().func_151518_m();
    public static List<RadiationEffectOutcome> globalEffectList = new ArrayList<RadiationEffectOutcome>();
    public static HashMap<Class<? extends EntityLivingBase>, List<RadiationEffectOutcome>> perEntityEffectList = new HashMap();
    public static HashMap<Class<? extends EntityLivingBase>, Float> perEntityRadiationScale = new HashMap();

    public static void setMaxRadiation(Class<? extends EntityLivingBase> clazz, float maxValue) {
        perEntityRadiationScale.put(clazz, Float.valueOf(ConfigRadiation.RADIATION_DEATH_POINT / maxValue));
    }

    public static void init() {
        globalEffectList.add(new REOPotion(() -> ConfigRadiation.RADIATION_SICKNESS_POINT, (entity, rads) -> Float.valueOf(RadiationEntityEventHandler.scaleChance(entity, rads.floatValue(), ConfigRadiation.RADIATION_SICKNESS_POINT)), entity -> new PotionEffect(MobEffects.field_76438_s, 100)));
        globalEffectList.add(new REOPotion(() -> ConfigRadiation.RADIATION_WEAKNESS_POINT, (entity, rads) -> Float.valueOf(RadiationEntityEventHandler.scaleChance(entity, rads.floatValue(), ConfigRadiation.RADIATION_WEAKNESS_POINT)), entity -> {
            if (entity.func_130014_f_().field_73012_v.nextBoolean()) {
                return new PotionEffect(MobEffects.field_76437_t, 100);
            }
            if (entity.func_130014_f_().field_73012_v.nextBoolean()) {
                return new PotionEffect(MobEffects.field_76419_f, 100);
            }
            if (entity.func_130014_f_().field_73012_v.nextBoolean()) {
                return new PotionEffect(MobEffects.field_76421_d, 100);
            }
            return null;
        }));
        globalEffectList.add(new REOPotion(() -> ConfigRadiation.RADIATION_CONFUSION_POINT, (entity, rads) -> Float.valueOf(RadiationEntityEventHandler.scaleChance(entity, rads.floatValue(), ConfigRadiation.RADIATION_CONFUSION_POINT)), entity -> new PotionEffect(MobEffects.field_76440_q, 100)));
        globalEffectList.add(new RadiationEffectOutcome(() -> ConfigRadiation.RADIATION_DEATH_POINT, (entity, rads, env) -> {
            float check = 25.0f;
            if (env > 25.0f) {
                float scale = env / 25.0f;
                SourceWrapperPosition sourceWrapperPosition = new SourceWrapperPosition(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                ASIndirectEffects.applyIndirectEffect(entity, AtomicScienceAPI.RADIATION_DAMAGE, sourceWrapperPosition, 1.0f * scale);
            }
        }));
        globalEffectList.add(new RadiationEffectOutcome(() -> ConfigRadiation.RADIATION_DEATH_POINT, (entity, rads, env) -> {
            if (RadiationEntityEventHandler.scaleToEntity(entity, rads) > ConfigRadiation.RADIATION_DEATH_POINT) {
                entity.func_70097_a(radiationDeathDamage, 5.0f);
            }
        }));
        RadiationEntityEventHandler.setMaxRadiation(EntityBat.class, 200.0f);
        RadiationEntityEventHandler.setMaxRadiation(EntityChicken.class, 400.0f);
        RadiationEntityEventHandler.setMaxRadiation(EntityParrot.class, 400.0f);
        RadiationEntityEventHandler.setMaxRadiation(EntityRabbit.class, 1000.0f);
        RadiationEntityEventHandler.setMaxRadiation(EntityOcelot.class, 2000.0f);
        RadiationEntityEventHandler.setMaxRadiation(EntityWolf.class, 2500.0f);
        RadiationEntityEventHandler.setMaxRadiation(EntitySheep.class, 3000.0f);
        RadiationEntityEventHandler.setMaxRadiation(EntityCow.class, 5000.0f);
        RadiationEntityEventHandler.setMaxRadiation(EntityPig.class, 5000.0f);
        RadiationEntityEventHandler.setMaxRadiation(EntityEndermite.class, 1000.0f);
        RadiationEntityEventHandler.setMaxRadiation(EntitySilverfish.class, 1000.0f);
        RadiationEntityEventHandler.setMaxRadiation(EntitySlime.class, 8000.0f);
        RadiationEntityEventHandler.setMaxRadiation(EntityZombie.class, 15000.0f);
        RadiationEntityEventHandler.setMaxRadiation(EntitySkeleton.class, 25000.0f);
        RadiationEntityEventHandler.setMaxRadiation(EntityShulker.class, 35000.0f);
        RadiationEntityEventHandler.setMaxRadiation(EntityEnderman.class, 45000.0f);
    }

    public static float scaleChance(EntityLivingBase entityLivingBase, float rads, float checkRads) {
        return (RadiationEntityEventHandler.scaleToEntity(entityLivingBase, rads) - checkRads) / (ConfigRadiation.RADIATION_DEATH_POINT - checkRads);
    }

    public static float scaleToEntity(EntityLivingBase entity, float rads) {
        Class<?> clazz = entity.getClass();
        if (perEntityRadiationScale.containsKey(clazz)) {
            return perEntityRadiationScale.get(clazz).floatValue() * rads;
        }
        return rads;
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity;
        if (!event.getEntity().func_130014_f_().field_72995_K && (entity = event.getEntityLiving()).func_70089_S()) {
            if (!(entity.func_82150_aj() || entity instanceof EntityPlayerMP && ((EntityPlayerMP)entity).field_71075_bZ.field_75098_d)) {
                float remExposure = MapHandler.RADIATION_MAP.getRemExposure((Entity)entity);
                this.applyExposure(entity, remExposure);
                float rad = ASIndirectEffects.getRadiation((Entity)entity);
                if (entity.field_70173_aa % 5 == 0) {
                    globalEffectList.forEach(effect -> effect.applyEffects(entity, rad, remExposure));
                    Class<?> clazz = entity.getClass();
                    if (perEntityEffectList.containsKey(clazz)) {
                        perEntityEffectList.get(clazz).forEach(effect -> effect.applyEffects(entity, rad, remExposure));
                    }
                }
            }
            if (entity instanceof EntityPlayerMP) {
                this.syncPlayerData((EntityPlayerMP)entity);
            }
        }
    }

    protected void applyExposure(EntityLivingBase entity, float remExposure) {
        if (remExposure > 0.0f) {
            SourceWrapperPosition sourceWrapperPosition = new SourceWrapperPosition(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            ASIndirectEffects.applyIndirectEffect(entity, AtomicScienceAPI.RADIATION, sourceWrapperPosition, remExposure);
        } else if (ASIndirectEffects.hasRadiationData((Entity)entity)) {
            NBTTagCompound data = ASIndirectEffects.getRadiationData((Entity)entity, false);
            int removeTimer = data.func_74762_e("remove_timer");
            if (removeTimer > ConfigRadiation.RAD_REMOVE_TIMER) {
                float rad = ASIndirectEffects.getRadiation((Entity)entity);
                if (rad <= ConfigRadiation.RAD_REMOVE_LOWER_LIMIT) {
                    ASIndirectEffects.setRadiation((Entity)entity, 0.0f);
                } else {
                    float amountToRemove = rad * ConfigRadiation.RAD_REMOVE_PERCENTAGE;
                    ASIndirectEffects.removeRadiation((Entity)entity, amountToRemove);
                }
                data.func_74768_a("remove_timer", 0);
            } else {
                data.func_74768_a("remove_timer", removeTimer + 1);
            }
        }
    }

    protected void syncPlayerData(EntityPlayerMP player) {
        boolean sendPacket = false;
        if (ASIndirectEffects.hasRadiationData((Entity)player)) {
            NBTTagCompound data = ASIndirectEffects.getRadiationData((Entity)player, false);
            float syncError = 0.001f;
            float exposure = MapHandler.RADIATION_MAP.getRemExposure((Entity)player);
            float prev_exposure = data.func_74760_g("prev_env_rads");
            float delta_exposure = Math.abs(prev_exposure - exposure);
            float rad = data.func_74760_g("rads");
            float prev_rad = data.func_74760_g("prev_rads");
            float delta_rad = Math.abs(prev_rad - rad);
            if (delta_rad > 0.001f || delta_exposure > 0.001f || player.field_70173_aa % 20 == 0) {
                sendPacket = true;
                data.func_74776_a("prev_rads", rad);
                data.func_74776_a("prev_env_rads", exposure);
            }
        }
        if (sendPacket || player.field_70173_aa % 5 == 0) {
            RadiationEntityEventHandler.sendPacket(player);
        }
    }

    public static void sendPacket(EntityPlayerMP player) {
        NBTTagCompound data = ASIndirectEffects.getRadiationData((Entity)player, false);
        PacketSystem.INSTANCE.sendToPlayer(new PacketPlayerRadiation(data.func_74760_g("rads"), MapHandler.RADIATION_MAP.getRemExposure((Entity)player), data.func_74762_e("remove_timer")), (EntityPlayer)player);
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        if (!event.getEntity().func_130014_f_().field_72995_K && event.getEntity() instanceof EntityPlayerMP) {
            float remExposure = MapHandler.RADIATION_MAP.getRemExposure(event.getEntity());
            System.out.println(remExposure);
            PacketSystem.INSTANCE.sendToPlayer(new PacketPlayerRadiation(0.0f, 0.0f, 0), (EntityPlayer)((EntityPlayerMP)event.getEntity()));
        }
    }
}

