/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.armor;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.api.AtomicScienceAPI;
import com.builtbroken.atomic.api.armor.IAntiPoisonArmor;
import com.builtbroken.atomic.api.effect.IIndirectEffectInstance;
import com.builtbroken.atomic.content.ASItems;
import com.builtbroken.atomic.content.armor.ArmorRadiationHandler;
import com.builtbroken.atomic.lib.LanguageUtility;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHazmatColor
extends ItemArmor
implements IAntiPoisonArmor {
    public static int damagePerTick = 1;
    public static int damagePerAttack = 100;
    private static final Color color = new Color(10067976);

    public ItemHazmatColor(EntityEquipmentSlot slot, String type) {
        super(ASItems.hazmatArmorMaterialColor, 0, slot);
        this.func_77637_a(AtomicScience.creativeTab);
        this.func_77655_b("atomicscience:hazmat." + type + ".color");
        this.setRegistryName("atomicscience:hazmat_color_" + type);
        this.func_77656_e(200000);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        LanguageUtility.getLocal("item.atomicscience:hazmat.color.info", tooltip);
    }

    public boolean func_82816_b_(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        return nbttagcompound != null && nbttagcompound.func_150297_b("display", 10) ? nbttagcompound.func_74775_l("display").func_150297_b("color", 3) : false;
    }

    public int func_82814_b(ItemStack stack) {
        NBTTagCompound nbttagcompound1;
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound != null && (nbttagcompound1 = nbttagcompound.func_74775_l("display")) != null && nbttagcompound1.func_150297_b("color", 3)) {
            return nbttagcompound1.func_74762_e("color");
        }
        return color.getRGB();
    }

    public void func_82815_c(ItemStack stack) {
        NBTTagCompound nbttagcompound1;
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound != null && (nbttagcompound1 = nbttagcompound.func_74775_l("display")).func_74764_b("color")) {
            nbttagcompound1.func_82580_o("color");
        }
    }

    public void func_82813_b(ItemStack stack, int color) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound == null) {
            nbttagcompound = new NBTTagCompound();
            stack.func_77982_d(nbttagcompound);
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("display");
        if (!nbttagcompound.func_150297_b("display", 10)) {
            nbttagcompound.func_74782_a("display", (NBTBase)nbttagcompound1);
        }
        nbttagcompound1.func_74768_a("color", color);
    }

    @Override
    public boolean doesArmorProtectFromSource(ItemStack itemStack, EntityLivingBase entity, IIndirectEffectInstance instance) {
        if (this.isFullArmorSetNeeded(itemStack, entity, instance) && !ArmorRadiationHandler.hasFullSetOfArmor(entity)) {
            return false;
        }
        return instance.getIndirectEffectType() == AtomicScienceAPI.RADIATION || instance.getIndirectEffectType() == AtomicScienceAPI.RADIATION_DAMAGE;
    }

    @Override
    public boolean isArmorPartOfSet(ItemStack armorStack, ItemStack compareStack) {
        return armorStack.func_77973_b() instanceof ItemHazmatColor && compareStack.func_77973_b() instanceof ItemHazmatColor;
    }

    @Override
    public void onArmorProtectFromSource(ItemStack itemStack, EntityLivingBase entityLiving, IIndirectEffectInstance instance) {
        if (instance.getIndirectEffectType() == AtomicScienceAPI.RADIATION) {
            // empty if block
        }
    }

    @Override
    public EntityEquipmentSlot getArmorSlot() {
        return this.field_77881_a;
    }
}

