/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.armor;

import com.builtbroken.atomic.api.armor.IArmorSet;
import com.builtbroken.atomic.content.armor.ArmorRadData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="atomicscience")
public class ArmorRadiationHandler {
    private static final EntityEquipmentSlot[] CHECK_SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.FEET, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.HEAD};
    private static final List<ArmorRadData> armorRadiationList = new ArrayList<ArmorRadData>();

    public static boolean isRadiationResistantArmor(ItemStack stack) {
        return ArmorRadiationHandler.getArmorRadData(stack) != null;
    }

    public static ArmorRadData getArmorRadData(ItemStack stack) {
        return ArmorRadiationHandler.getArmorRadData(stack, false);
    }

    public static ArmorRadData getArmorRadData(ItemStack stack, boolean create) {
        for (ArmorRadData data : armorRadiationList) {
            if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)data.item) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)data.item)) continue;
            return data;
        }
        if (create) {
            ArmorRadData data = new ArmorRadData(stack.func_77946_l());
            armorRadiationList.add(data);
            return data;
        }
        return null;
    }

    protected static boolean hasFullSetOfArmor(EntityLivingBase entity) {
        ItemStack compareStack = null;
        for (EntityEquipmentSlot entityEquipmentSlot : CHECK_SLOTS) {
            ItemStack slotStack = entity.func_184582_a(entityEquipmentSlot);
            if (slotStack.func_77973_b() instanceof IArmorSet) {
                if (compareStack == null) {
                    compareStack = slotStack;
                    continue;
                }
                if (((IArmorSet)slotStack.func_77973_b()).isArmorPartOfSet(compareStack, slotStack)) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

