/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.armor;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.content.armor.ArmorRadLevelData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;

public class ArmorRadData {
    public final ItemStack item;
    public final List<ArmorRadLevelData> radiationLevels = new ArrayList<ArmorRadLevelData>();
    private boolean needsSorted = false;

    public ArmorRadData(ItemStack item) {
        this.item = item;
    }

    public boolean addRadiationLevel(ArmorRadLevelData data) {
        if (data != null) {
            for (ArmorRadLevelData armorRadLevelData : this.radiationLevels) {
                if (armorRadLevelData.levelStart != data.levelStart) continue;
                AtomicScience.logger.error("ArmorRadData[" + this.item + " | " + this.item.func_82833_r() + "] Attempt at adding radiation level matching an existing level. \nCurrent: " + armorRadLevelData + "\nNew: " + data, (Throwable)new RuntimeException("trace"));
                return false;
            }
            this.radiationLevels.add(data);
            this.needsSorted = true;
            return true;
        }
        return false;
    }

    public float applyProtection(float rad) {
        ArmorRadLevelData best;
        if (this.radiationLevels.size() == 0) {
            return rad;
        }
        if (this.needsSorted) {
            this.needsSorted = false;
            Collections.sort(this.radiationLevels);
        }
        if ((best = this.getBestProtection(rad)) != null) {
            float new_rad = rad - best.protection_flat;
            new_rad -= new_rad * best.protection_percent;
            return Math.max(0.0f, Math.min(rad, new_rad));
        }
        return rad;
    }

    public ArmorRadLevelData getBestProtection(float rad) {
        ArmorRadLevelData best = this.radiationLevels.get(0);
        for (int i = 1; i < this.radiationLevels.size(); ++i) {
            ArmorRadLevelData data = this.radiationLevels.get(i);
            if (data.levelStart <= rad && data.levelStart > best.levelStart) {
                best = data;
                continue;
            }
            if (data.levelStart > rad) break;
        }
        return best;
    }
}

