/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content;

import com.builtbroken.atomic.api.AtomicScienceAPI;
import com.builtbroken.atomic.api.armor.IAntiPoisonArmor;
import com.builtbroken.atomic.api.effect.IIndirectEffectInstance;
import com.builtbroken.atomic.api.effect.IIndirectEffectSource;
import com.builtbroken.atomic.api.effect.IIndirectEffectType;
import com.builtbroken.atomic.config.logic.ConfigRadiation;
import com.builtbroken.atomic.content.effects.IndirectEffectInstance;
import com.builtbroken.atomic.content.effects.RadiationEntityEventHandler;
import com.builtbroken.atomic.content.effects.type.IETRadiation;
import com.builtbroken.atomic.content.effects.type.IETRadiationDamage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;

public class ASIndirectEffects {
    public static final String NBT_RADIATION_DATA = "atomicscience:radiation_data";
    public static final String NBT_RADS = "rads";
    public static final String NBT_RADS_PREV = "prev_rads";
    public static final String NBT_RADS_ENVIROMENT_PREV = "prev_env_rads";
    public static final String NBT_RADS_REMOVE_TIMER = "remove_timer";

    public static void register() {
        AtomicScienceAPI.RADIATION = new IETRadiation();
        AtomicScienceAPI.RADIATION_DAMAGE = new IETRadiationDamage();
        if (ConfigRadiation.ENABLE_EXPOSURE) {
            RadiationEntityEventHandler.init();
            MinecraftForge.EVENT_BUS.register((Object)new RadiationEntityEventHandler());
        }
    }

    public static NBTTagCompound getRadiationData(Entity entity, boolean init) {
        if (!ASIndirectEffects.hasRadiationData(entity) && init) {
            entity.getEntityData().func_74782_a(NBT_RADIATION_DATA, (NBTBase)new NBTTagCompound());
        }
        return entity.getEntityData().func_74775_l(NBT_RADIATION_DATA);
    }

    public static void setRadiation(Entity entity, float value) {
        NBTTagCompound data = ASIndirectEffects.getRadiationData(entity, true);
        data.func_74776_a(NBT_RADS, value);
    }

    public static float getRadiation(Entity entity) {
        if (ASIndirectEffects.hasRadiationData(entity)) {
            return ASIndirectEffects.getRadiationData(entity, true).func_74760_g(NBT_RADS);
        }
        return 0.0f;
    }

    public static void addRadiation(Entity entity, float value) {
        float current = ASIndirectEffects.getRadiation(entity);
        ASIndirectEffects.setRadiation(entity, current += value);
        NBTTagCompound data = ASIndirectEffects.getRadiationData(entity, true);
        data.func_74768_a(NBT_RADS_REMOVE_TIMER, 0);
    }

    public static void removeRadiation(Entity entity, float value) {
        float current = ASIndirectEffects.getRadiation(entity);
        ASIndirectEffects.setRadiation(entity, Math.max(0.0f, current -= value));
    }

    public static boolean hasRadiationData(Entity entity) {
        return entity.getEntityData().func_150297_b(NBT_RADIATION_DATA, 10);
    }

    public static void applyIndirectEffect(EntityLivingBase entity, IIndirectEffectType type, IIndirectEffectSource source, float amount) {
        IndirectEffectInstance indirectEffectInstance = new IndirectEffectInstance(type, source, amount);
        ASIndirectEffects.applyIndirectEffect(entity, indirectEffectInstance);
    }

    public static void applyIndirectEffect(EntityLivingBase entity, IIndirectEffectInstance indirectEffectInstance) {
        if (ASIndirectEffects.isProtected(entity, indirectEffectInstance)) {
            ASIndirectEffects.onProtected(entity, indirectEffectInstance);
        } else {
            indirectEffectInstance.applyIndirectEffect((Entity)entity);
        }
    }

    public static boolean isProtected(EntityLivingBase entity, IIndirectEffectInstance indirectEffectInstance) {
        for (int i = 2; i < 6; ++i) {
            ItemStack stack = entity.func_184582_a(EntityEquipmentSlot.values()[i]);
            if (stack == null || !(stack.func_77973_b() instanceof IAntiPoisonArmor) || !((IAntiPoisonArmor)stack.func_77973_b()).doesArmorProtectFromSource(stack, entity, indirectEffectInstance)) continue;
            return true;
        }
        return false;
    }

    public static void onProtected(EntityLivingBase entity, IIndirectEffectInstance indirectEffectInstance) {
        for (int i = 2; i < 6; ++i) {
            ItemStack stack = entity.func_184582_a(EntityEquipmentSlot.values()[i]);
            if (stack == null || !(stack.func_77973_b() instanceof IAntiPoisonArmor)) continue;
            ((IAntiPoisonArmor)stack.func_77973_b()).onArmorProtectFromSource(stack, entity, indirectEffectInstance);
        }
    }
}

