/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.proxy.ContentProxy;
import java.io.File;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public enum ASFluids {
    ANTIMATTER("atomicscience:antimatter", "plasma", false),
    STRANGE_MATTER("atomicscience:strange_matter", "plasma", false),
    DEUTERIUM("atomicscience:deuterium", "tritium", false),
    STEAM("steam", "steam", true),
    REACTOR_WASTE("atomicscience:reactor_waste", "toxic/reactor/still", "toxic/reactor/flow", true),
    LIQUID_MINERAL_WASTE("atomicscience:mineral_waste", "toxic/mineral/still", "toxic/mineral/flow", true),
    CONTAMINATED_MINERAL_WATER("atomicscience:contaminated_mineral_water", "water/mineral/still", "water/mineral/flow", true),
    CONTAMINATED_WATER("atomicscience:contaminated_water", "water/contaminated/still", "water/contaminated/flow", true),
    URANIUM_HEXAFLOURIDE("atomicscience:uranium_hexafluoride", "uranium.hexafluoride", false);

    public final String id;
    public final String texture_still;
    public final String texture_flow;
    public final boolean makeBlock;
    public Fluid fluid;

    private ASFluids(String id, boolean makeBlock) {
        this(id, null, null, makeBlock);
    }

    private ASFluids(String id, String texture, boolean makeBlock) {
        this(id, texture, texture, makeBlock);
    }

    private ASFluids(String id, String texture_still, String texture_flow, boolean makeBlock) {
        this.id = id;
        this.texture_still = texture_still;
        this.texture_flow = texture_flow;
        this.makeBlock = makeBlock;
    }

    protected void register(Configuration configuration) {
        if (this.fluid == null) {
            this.fluid = this.texture_still != null ? new Fluid(this.id, new ResourceLocation("atomicscience", "blocks/fluids/" + this.texture_still), new ResourceLocation("atomicscience", "blocks/fluids/" + this.texture_flow)) : new Fluid(this.id, FluidRegistry.WATER.getStill(), FluidRegistry.WATER.getFlowing());
        }
        if (!this.id.startsWith("atomicscience:")) {
            this.fluid.setUnlocalizedName("atomicscience:" + this.id);
        }
        if (!FluidRegistry.registerFluid((Fluid)this.fluid)) {
            this.fluid = FluidRegistry.getFluid((String)this.id);
        }
    }

    public static class Proxy
    extends ContentProxy {
        public Proxy() {
            super("fluids");
        }

        @Override
        public void preInit() {
            Configuration configuration = new Configuration(new File(AtomicScience.configFolder, "Fluids.cfg"), "1.12.2-3.2.0.3");
            configuration.load();
            for (ASFluids fluid : ASFluids.values()) {
                fluid.register(configuration);
            }
            configuration.save();
            ASFluids.STEAM.fluid.setGaseous(true);
            ASFluids.DEUTERIUM.fluid.setGaseous(true);
            ASFluids.URANIUM_HEXAFLOURIDE.fluid.setGaseous(true);
        }
    }
}

