/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.client;

import com.builtbroken.atomic.CommonProxy;
import com.builtbroken.atomic.client.ParticleSpawnFunction;
import com.builtbroken.atomic.client.fx.FxSmoke;
import com.builtbroken.atomic.config.client.ConfigClient;
import com.builtbroken.atomic.content.ASItems;
import com.builtbroken.atomic.content.armor.ArmorRadData;
import com.builtbroken.atomic.content.armor.ArmorRadLevelData;
import com.builtbroken.atomic.content.armor.ArmorRadiationHandler;
import com.builtbroken.atomic.content.machines.laser.emitter.LaserModes;
import com.builtbroken.atomic.network.netty.PacketSystem;
import com.builtbroken.atomic.network.packet.trigger.PacketMouse;
import java.awt.Color;
import java.util.HashMap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.particle.Particle;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Keyboard;

public class ClientProxy
extends CommonProxy {
    public static float RAD_EXPOSURE = 0.0f;
    public static float RAD_PLAYER = 0.0f;
    public static int RAD_REMOVE_TIMER = 0;
    public static float PREV_RAD_EXPOSURE = 0.0f;
    public static float PREV_RAD_PLAYER = 0.0f;
    public static final HashMap<String, ParticleSpawnFunction> PARTICLE_HANDLERS = new HashMap();
    private final float[] colorGetArray = new float[4];

    public ClientProxy() {
        super("ClientProxy");
    }

    @Override
    public void preInit() {
        OBJLoader.INSTANCE.addDomain("atomicscience");
        MinecraftForge.EVENT_BUS.register((Object)this);
        PARTICLE_HANDLERS.put("laser:normal", (x, y, z, vx, vy, vz) -> this.lazer(x, y, z, LaserModes.NORMAL));
        PARTICLE_HANDLERS.put("laser:field", (x, y, z, vx, vy, vz) -> this.lazer(x, y, z, LaserModes.FIELD));
        PARTICLE_HANDLERS.put("laser:normal.fire", (x, y, z, vx, vy, vz) -> this.lazerFire(x, y, z, vx, vy, vz, LaserModes.NORMAL));
        PARTICLE_HANDLERS.put("laser:field.fire", (x, y, z, vx, vy, vz) -> this.lazerFire(x, y, z, vx, vy, vz, LaserModes.FIELD));
    }

    @Override
    public void init() {
        super.init();
    }

    @SubscribeEvent
    public void mouseEvent(MouseEvent e) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        for (EnumHand hand : EnumHand.values()) {
            ItemStack stack = player.func_184586_b(hand);
            if (stack.func_77973_b() != ASItems.itemWrench) continue;
            if (!player.func_70093_af() || e.getDwheel() == 0) break;
            boolean ctrl = Keyboard.isKeyDown((int)157) || Keyboard.isKeyDown((int)29);
            PacketSystem.INSTANCE.sendToServer(new PacketMouse(player.field_71071_by.field_70461_c, ctrl, e.getDwheel() > 0));
            e.setCanceled(true);
            break;
        }
    }

    @SubscribeEvent
    public void onToolTip(ItemTooltipEvent event) {
        ArmorRadData armorRadData = ArmorRadiationHandler.getArmorRadData(event.getItemStack());
        if (armorRadData != null) {
            for (int i = 0; i < armorRadData.radiationLevels.size(); ++i) {
                ArmorRadLevelData armorRadLevelData = armorRadData.radiationLevels.get(i);
                String prefx = "[" + i + "] ";
                event.getToolTip().add(prefx + armorRadLevelData.levelStart + "rads");
                event.getToolTip().add(ClientProxy.padLeft("  -" + armorRadLevelData.protection_percent + "%  -" + armorRadLevelData.protection_flat, prefx.length() + 1));
            }
        }
    }

    public static final FontRenderer getFont(ItemStack stack) {
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font != null) {
            return font;
        }
        return Minecraft.func_71410_x().field_71466_p;
    }

    private static String padLeft(String s, int n) {
        return String.format("%1$" + n + "s", s);
    }

    @Override
    public void spawnParticle(String particle, double x, double y, double z, double vx, double vy, double vz) {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            if (PARTICLE_HANDLERS.containsKey(particle)) {
                PARTICLE_HANDLERS.get(particle).spawn(x, y, z, vx, vy, vz);
            } else if (!particle.startsWith("steam")) {
                if (particle.startsWith("reactor:running")) {
                    this.reactorRunning(x, y, z);
                } else if (particle.startsWith("boiling")) {
                    int count = Integer.parseInt(particle.split(";")[1]);
                    this.boiling(x, y, z, count);
                } else if (particle.equalsIgnoreCase("boiler:complete")) {
                    this.boilerComplete(x, y, z);
                } else if (particle.equalsIgnoreCase("boiler:running")) {
                    this.centrifugeRunning(x, y, z);
                } else if (particle.equalsIgnoreCase("centrifuge:complete")) {
                    this.centrifugeComplete(x, y, z);
                } else if (particle.equalsIgnoreCase("centrifuge:running")) {
                    this.centrifugeRunning(x, y, z);
                } else if (particle.equalsIgnoreCase("extractor:complete")) {
                    this.extractorComplete(x, y, z, (int)vx);
                } else if (particle.equalsIgnoreCase("extractor:running")) {
                    this.extractorRunning(x, y, z, (int)vx);
                } else if (particle.equalsIgnoreCase("accelerator:particle")) {
                    Minecraft.func_71410_x().field_71441_e.func_175688_a(EnumParticleTypes.HEART, x + this.r(0.4), y + 0.6 + this.r(0.1), z + this.r(0.4), 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    private void boiling(double x, double y, double z, int count) {
        if (ConfigClient.PARTICLES.BOILING_EFFECT) {
            int xi = (int)Math.floor(x);
            int yi = (int)Math.floor(y);
            int zi = (int)Math.floor(z);
            BlockPos blockPos = new BlockPos(xi, yi, zi);
            IBlockState blockState = Minecraft.func_71410_x().field_71441_e.func_180495_p(blockPos.func_177984_a());
            boolean isAir = blockState.func_177230_c().isAir(blockState, (IBlockAccess)Minecraft.func_71410_x().field_71441_e, blockPos.func_177984_a());
            for (int i = 0; i < count; ++i) {
                if (isAir) {
                    Minecraft.func_71410_x().field_71441_e.func_175688_a(EnumParticleTypes.WATER_SPLASH, x + this.r(0.4), y + 0.6 + this.r(0.1), z + this.r(0.4), 0.0, 0.0, 0.0, new int[0]);
                }
                Minecraft.func_71410_x().field_71441_e.func_175688_a(EnumParticleTypes.WATER_BUBBLE, x + this.r(0.5), y + this.r(0.5), z + this.r(0.5), this.r(0.1) - this.r(0.1), this.r(0.1), this.r(0.1) - this.r(0.1), new int[0]);
            }
        }
    }

    private void boilerComplete(double x, double y, double z) {
        if (ConfigClient.PARTICLES.MACHINE_COMPLETE) {
            FxSmoke smoke;
            int i;
            float randomSpeed = 0.05f;
            int rand = Minecraft.func_71410_x().field_71441_e.field_73012_v.nextInt(5);
            Color color = Color.GREEN.darker().darker();
            for (i = 0; i < 10 + rand; ++i) {
                smoke = new FxSmoke((World)Minecraft.func_71410_x().field_71441_e, x, y - 0.3, z, this.r(0.05f) - this.r(0.05f), this.r(0.05f) - this.r(0.05f), this.r(0.05f) - this.r(0.05f), (float)(1.0 - this.r(0.2) + this.r(0.2)));
                if (this.r(1.0) > 0.5) {
                    color.darker();
                }
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)smoke.setColor(color));
            }
            for (i = 0; i < 10 + rand; ++i) {
                smoke = new FxSmoke((World)Minecraft.func_71410_x().field_71441_e, x, y, z, this.r(0.05f) - this.r(0.05f), this.r(0.05f) - this.r(0.05f), this.r(0.05f) - this.r(0.05f), (float)(1.0 - this.r(0.2) + this.r(0.2)));
                if (this.r(1.0) > 0.5) {
                    color.darker();
                }
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)smoke.setColor(color));
            }
        }
    }

    private void centrifugeComplete(double x, double y, double z) {
        if (ConfigClient.PARTICLES.MACHINE_COMPLETE) {
            float randomSpeed = 0.05f;
            int rand = Minecraft.func_71410_x().field_71441_e.field_73012_v.nextInt(5);
            Color color = Color.GREEN.darker().darker();
            for (int i = 0; i < 10 + rand; ++i) {
                FxSmoke smoke = new FxSmoke((World)Minecraft.func_71410_x().field_71441_e, x, y, z, this.r(0.05f) - this.r(0.05f), this.r(0.05f) - this.r(0.05f), this.r(0.05f) - this.r(0.05f), (float)(1.0 - this.r(0.2) + this.r(0.2)));
                if (this.r(1.0) > 0.5) {
                    color.darker();
                }
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)smoke.setColor(color));
            }
        }
    }

    private void centrifugeRunning(double x, double y, double z) {
        if (ConfigClient.PARTICLES.MACHINE_RUNNING) {
            float randomSpeed = 0.02f;
            FxSmoke smoke = new FxSmoke((World)Minecraft.func_71410_x().field_71441_e, x, y, z, this.r(0.02f) - this.r(0.02f), this.r(0.02f) - this.r(0.02f), this.r(0.02f) - this.r(0.02f), (float)(1.0 - this.r(0.2) + this.r(0.2)));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)smoke.setColor(Color.GREEN));
        }
    }

    private void extractorComplete(double x, double y, double z, int facing) {
        if (ConfigClient.PARTICLES.MACHINE_COMPLETE) {
            float randomSpeed = 0.05f;
            int rand = Minecraft.func_71410_x().field_71441_e.field_73012_v.nextInt(5);
            Color color = Color.GREEN.darker().darker();
            EnumFacing direction = EnumFacing.func_82600_a((int)facing);
            for (int i = 0; i < 10 + rand; ++i) {
                FxSmoke smoke = new FxSmoke((World)Minecraft.func_71410_x().field_71441_e, x + (double)direction.func_82601_c() * 0.2, y + (double)direction.func_96559_d() * 0.2, z + (double)direction.func_82599_e() * 0.2, this.r(0.05f) - this.r(0.05f), this.r(0.05f) - this.r(0.05f), this.r(0.05f) - this.r(0.05f), (float)(1.0 - this.r(0.2) + this.r(0.2)));
                if (this.r(1.0) > 0.5) {
                    color.darker();
                }
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)smoke.setColor(color));
            }
        }
    }

    private void extractorRunning(double x, double y, double z, int facing) {
        if (ConfigClient.PARTICLES.MACHINE_RUNNING) {
            float randomSpeed = 0.02f;
            EnumFacing direction = EnumFacing.func_82600_a((int)facing);
            FxSmoke smoke = new FxSmoke((World)Minecraft.func_71410_x().field_71441_e, x + (double)direction.func_82601_c() * 0.2, y + (double)direction.func_96559_d() * 0.2, z + (double)direction.func_82599_e() * 0.2, this.r(0.02f) - this.r(0.02f), this.r(0.02f) - this.r(0.02f), this.r(0.02f) - this.r(0.02f), (float)(1.0 - this.r(0.2) + this.r(0.2)));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)smoke.setColor(Color.GREEN));
            smoke = new FxSmoke((World)Minecraft.func_71410_x().field_71441_e, x + (double)direction.func_82601_c() * 0.2 + (double)direction.func_82599_e() * 0.3, y + (double)direction.func_96559_d() * 0.2, z + (double)direction.func_82599_e() * 0.2 + (double)direction.func_82601_c() * 0.3, this.r(0.02f) - this.r(0.02f), this.r(0.02f) - this.r(0.02f), this.r(0.02f) - this.r(0.02f), (float)(1.0 - this.r(0.2) + this.r(0.2)));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)smoke.setColor(Color.GREEN));
            smoke = new FxSmoke((World)Minecraft.func_71410_x().field_71441_e, x + (double)direction.func_82601_c() * 0.2 - (double)direction.func_82599_e() * 0.3, y + (double)direction.func_96559_d() * 0.2, z + (double)direction.func_82599_e() * 0.2 - (double)direction.func_82601_c() * 0.3, this.r(0.02f) - this.r(0.02f), this.r(0.02f) - this.r(0.02f), this.r(0.02f) - this.r(0.02f), (float)(1.0 - this.r(0.2) + this.r(0.2)));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)smoke.setColor(Color.GREEN));
        }
    }

    private void lazer(double x, double y, double z, LaserModes laserModes) {
        for (int i = 0; i < 2; ++i) {
            this.spawnParticle(EnumParticleTypes.REDSTONE, x + 0.05 * Math.random(), y + 0.05 * Math.random(), z + 0.05 * Math.random(), laserModes.color);
        }
    }

    private void lazerFire(double sx, double sy, double sz, double ex, double ey, double ez, LaserModes laserModes) {
        double deltaX = ex - sx;
        double deltaY = ey - sy;
        double deltaZ = ez - sz;
        double distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
        double vx = deltaX / distance;
        double vy = deltaY / distance;
        double vz = deltaZ / distance;
        int steps = (int)Math.ceil(distance / 0.2);
        double dStep = distance / (double)steps;
        for (int step = 0; step < steps; ++step) {
            double px = sx + dStep * (double)step * vx;
            double py = sy + dStep * (double)step * vy;
            double pz = sz + dStep * (double)step * vz;
            this.spawnParticle(EnumParticleTypes.REDSTONE, px, py, pz, laserModes.color);
        }
        if (laserModes == LaserModes.FIELD) {
            float rd = 0.3f;
            for (int i = 0; i < 2; ++i) {
                double px = ex + Math.random() * (double)0.3f - Math.random() * (double)0.3f;
                double py = ey + Math.random() * (double)0.3f - Math.random() * (double)0.3f;
                double pz = ez + Math.random() * (double)0.3f - Math.random() * (double)0.3f;
                this.spawnParticle(EnumParticleTypes.REDSTONE, px, py, pz, laserModes.color);
            }
        }
    }

    private void spawnParticle(EnumParticleTypes type, double x, double y, double z) {
        this.spawnParticle(type, x, y, z, 0.0, 0.0, 0.0, new int[0]);
    }

    private void spawnParticle(EnumParticleTypes type, double x, double y, double z, Color color) {
        float[] colors = color.getRGBComponents(this.colorGetArray);
        this.spawnParticle(type, x, y, z, colors[0], colors[1], colors[2], new int[0]);
    }

    private void spawnParticle(EnumParticleTypes type, double x, double y, double z, double vx, double vy, double vz, int ... nums) {
        Minecraft.func_71410_x().field_71452_i.func_178927_a(type.func_179348_c(), x, y, z, vx, vy, vz, nums);
    }

    private void reactorRunning(double x, double y, double z) {
        if (ConfigClient.PARTICLES.REACTOR_RUNNING) {
            float randomSpeed = 0.05f;
            Color color = Color.GREEN;
            for (int j = 0; j < 6; ++j) {
                for (int i = 0; i < 4; ++i) {
                    FxSmoke smoke = new FxSmoke((World)Minecraft.func_71410_x().field_71441_e, x + this.r(0.01) - this.r(0.01), y + 0.15 - 0.15 * (double)j, z + this.r(0.01) - this.r(0.01), this.r(0.05f) - this.r(0.05f), this.r(0.01) - this.r(0.01), this.r(0.05f) - this.r(0.05f), (float)(1.0 - this.r(0.2) + this.r(0.2))).setColor(color).setYAcceleration(0.0);
                    color = this.r(1.0) > 0.5 ? color.darker() : color.brighter();
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)smoke);
                }
            }
        }
    }

    private double r(double random) {
        return Math.random() * random - Math.random() * random;
    }
}

