/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.api.accelerator;

import com.builtbroken.atomic.api.accelerator.IAcceleratorComponent;
import com.builtbroken.atomic.content.machines.accelerator.data.TubeConnectionType;
import com.builtbroken.atomic.content.machines.accelerator.data.TubeSide;
import com.builtbroken.atomic.content.machines.accelerator.data.TubeSideType;
import com.builtbroken.atomic.content.machines.accelerator.graph.AcceleratorNetwork;
import com.builtbroken.atomic.content.machines.accelerator.particle.AcceleratorParticle;
import java.util.List;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public interface IAcceleratorNode
extends IAcceleratorComponent {
    public IAcceleratorNode[] getNodes();

    public void update(World var1, int var2);

    public float move(AcceleratorParticle var1, float var2);

    public void setNetwork(AcceleratorNetwork var1);

    default public void onNetworkRemoved() {
    }

    public AcceleratorNetwork getNetwork();

    public List<AcceleratorParticle> getParticles();

    public boolean updateConnections(IBlockAccess var1);

    public void connect(IAcceleratorNode var1, EnumFacing var2);

    public void onParticleEnter(AcceleratorParticle var1);

    public void onParticleExit(AcceleratorParticle var1);

    public EnumFacing getDirection();

    public TubeConnectionType getConnectionType();

    default public TubeSideType getConnectionState(EnumFacing facing) {
        return this.getConnectionState(TubeSide.getSideFacingOut(this.getDirection(), facing));
    }

    default public TubeSideType getConnectionState(TubeSide side) {
        return this.getConnectionType().getTypeForSide(side);
    }
}

