/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.api.accelerator;

import com.builtbroken.atomic.api.AtomicScienceAPI;
import com.builtbroken.atomic.api.accelerator.IAcceleratorMagnet;
import com.builtbroken.atomic.api.accelerator.IAcceleratorTube;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class AcceleratorHelpers {
    public static float getMagnetPower(TileEntity tileEntity, EnumFacing facing) {
        IAcceleratorMagnet magnet = AcceleratorHelpers.getAcceleratorMagnet(tileEntity, facing);
        if (magnet != null) {
            return magnet.getRawMagneticPower();
        }
        return 0.0f;
    }

    public static float getMagnetPower(IAcceleratorTube tube, TileEntity tileEntity, EnumFacing facing) {
        IAcceleratorMagnet magnet = AcceleratorHelpers.getAcceleratorMagnet(tileEntity, facing);
        if (magnet != null) {
            return magnet.getActualMagneticPower(tube);
        }
        return 0.0f;
    }

    public static IAcceleratorTube getAcceleratorTube(TileEntity tileEntity, EnumFacing facing) {
        if (tileEntity != null && tileEntity.hasCapability(AtomicScienceAPI.ACCELERATOR_TUBE_CAPABILITY, facing)) {
            return (IAcceleratorTube)tileEntity.getCapability(AtomicScienceAPI.ACCELERATOR_TUBE_CAPABILITY, facing);
        }
        return null;
    }

    public static IAcceleratorMagnet getAcceleratorMagnet(TileEntity tileEntity, EnumFacing facing) {
        if (tileEntity != null && tileEntity.hasCapability(AtomicScienceAPI.ACCELERATOR_MAGNET_CAPABILITY, facing)) {
            return (IAcceleratorMagnet)tileEntity.getCapability(AtomicScienceAPI.ACCELERATOR_MAGNET_CAPABILITY, facing);
        }
        return null;
    }
}

