/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic;

import com.builtbroken.atomic.CommonProxy;
import com.builtbroken.atomic.api.accelerator.IAcceleratorMagnet;
import com.builtbroken.atomic.api.accelerator.IAcceleratorTube;
import com.builtbroken.atomic.api.radiation.IRadiationResistant;
import com.builtbroken.atomic.api.radiation.IRadiationSource;
import com.builtbroken.atomic.api.thermal.IThermalSource;
import com.builtbroken.atomic.content.ASFluids;
import com.builtbroken.atomic.content.ASIndirectEffects;
import com.builtbroken.atomic.content.ASItems;
import com.builtbroken.atomic.content.ASWorldGen;
import com.builtbroken.atomic.content.armor.ArmorRadLevelData;
import com.builtbroken.atomic.content.armor.ArmorRadiationHandler;
import com.builtbroken.atomic.content.commands.CommandAS;
import com.builtbroken.atomic.content.machines.accelerator.magnet.CapabilityMagnet;
import com.builtbroken.atomic.content.machines.processing.ProcessorRecipeHandler;
import com.builtbroken.atomic.lib.MassHandler;
import com.builtbroken.atomic.lib.placement.PlacementQueue;
import com.builtbroken.atomic.lib.radiation.RadiationHandler;
import com.builtbroken.atomic.lib.thermal.ThermalHandler;
import com.builtbroken.atomic.map.MapHandler;
import com.builtbroken.atomic.map.exposure.node.RadSourceMap;
import com.builtbroken.atomic.map.exposure.thread.ThreadRadExposure;
import com.builtbroken.atomic.map.thermal.node.ThermalSourceMap;
import com.builtbroken.atomic.map.thermal.thread.ThreadThermalAction;
import com.builtbroken.atomic.network.netty.PacketSystem;
import com.builtbroken.atomic.proxy.Mods;
import com.builtbroken.atomic.proxy.ProxyLoader;
import com.builtbroken.atomic.proxy.bc.ProxyBuildcraftEnergy;
import com.builtbroken.atomic.proxy.eu.ProxyIC2;
import java.io.File;
import javax.annotation.Nullable;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="atomicscience", name="Atomic Science", version="1.12.2-3.2.0.3", dependencies="", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class AtomicScience {
    public static final String DOMAIN = "atomicscience";
    public static final String PREFIX = "atomicscience:";
    public static final String MAJOR_VERSION = "3";
    public static final String MINOR_VERSION = "2";
    public static final String REVISION_VERSION = "0";
    public static final String BUILD_VERSION = "3";
    public static final String MC_VERSION = "1.12.2";
    public static final String VERSION = "1.12.2-3.2.0.3";
    public static final String DEPENDENCIES = "";
    public static final String TEXTURE_DIRECTORY = "textures/";
    public static final String GUI_TEXTURE_DIRECTORY = "textures/gui/";
    public static final String MODEL_TEXTURE_DIRECTORY = "textures/models/";
    public static final int TICKS_SECOND = 20;
    public static final int TICKS_MIN = 1200;
    public static final int TICKS_HOUR = 72000;
    @Mod.Instance(value="atomicscience")
    public static AtomicScience INSTANCE;
    public static Logger logger;
    public static final boolean runningAsDev;
    public static CreativeTabs creativeTab;
    @SidedProxy(clientSide="com.builtbroken.atomic.client.ClientProxy", serverSide="com.builtbroken.atomic.ServerProxy")
    public static CommonProxy sideProxy;
    public static ProxyLoader proxyLoader;
    public static File configFolder;

    public AtomicScience() {
        if (runningAsDev) {
            FluidRegistry.enableUniversalBucket();
        }
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        configFolder = new File(event.getModConfigurationDirectory(), "/bbm/atomicscience");
        creativeTab = new CreativeTabs(DOMAIN){

            public ItemStack func_78016_d() {
                return new ItemStack((Item)ASItems.itemArmorHazmatHelm);
            }
        };
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)sideProxy);
        MinecraftForge.EVENT_BUS.register((Object)new PlacementQueue());
        MapHandler.register();
        ThermalHandler.init();
        RadiationHandler.init();
        MassHandler.init();
        proxyLoader = new ProxyLoader("AS");
        proxyLoader.add(new ASFluids.Proxy());
        proxyLoader.add(new ASWorldGen());
        proxyLoader.add(ProcessorRecipeHandler.INSTANCE);
        proxyLoader.add(PacketSystem.INSTANCE);
        proxyLoader.add(sideProxy);
        if (Mods.IC2.isLoaded()) {
            proxyLoader.add(new ProxyIC2());
        }
        if (Mods.BUILDCRAFT_ENERGY.isLoaded()) {
            proxyLoader.add(new ProxyBuildcraftEnergy());
        }
        ASIndirectEffects.register();
        proxyLoader.preInit();
        if (runningAsDev) {
            for (ASFluids value : ASFluids.values()) {
                FluidRegistry.addBucketForFluid((Fluid)value.fluid);
            }
        }
        this.registerCaps();
    }

    public void registerCaps() {
        CapabilityManager.INSTANCE.register(IRadiationSource.class, (Capability.IStorage)new Capability.IStorage<IRadiationSource>(){

            @Nullable
            public NBTBase writeNBT(Capability<IRadiationSource> capability, IRadiationSource instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability<IRadiationSource> capability, IRadiationSource instance, EnumFacing side, NBTBase nbt) {
            }
        }, () -> new RadSourceMap(0, BlockPos.field_177992_a, 0));
        CapabilityManager.INSTANCE.register(IThermalSource.class, (Capability.IStorage)new Capability.IStorage<IThermalSource>(){

            @Nullable
            public NBTBase writeNBT(Capability<IThermalSource> capability, IThermalSource instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability<IThermalSource> capability, IThermalSource instance, EnumFacing side, NBTBase nbt) {
            }
        }, () -> new ThermalSourceMap(0, BlockPos.field_177992_a, 0));
        CapabilityManager.INSTANCE.register(IRadiationResistant.class, (Capability.IStorage)new Capability.IStorage<IRadiationResistant>(){

            @Nullable
            public NBTBase writeNBT(Capability<IRadiationResistant> capability, IRadiationResistant instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability<IRadiationResistant> capability, IRadiationResistant instance, EnumFacing side, NBTBase nbt) {
            }
        }, () -> () -> 0.0f);
        CapabilityManager.INSTANCE.register(IAcceleratorMagnet.class, (Capability.IStorage)new Capability.IStorage<IAcceleratorMagnet>(){

            @Nullable
            public NBTBase writeNBT(Capability<IAcceleratorMagnet> capability, IAcceleratorMagnet instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability<IAcceleratorMagnet> capability, IAcceleratorMagnet instance, EnumFacing side, NBTBase nbt) {
            }
        }, () -> new CapabilityMagnet(null));
        CapabilityManager.INSTANCE.register(IAcceleratorTube.class, (Capability.IStorage)new Capability.IStorage<IAcceleratorTube>(){

            @Nullable
            public NBTBase writeNBT(Capability<IAcceleratorTube> capability, IAcceleratorTube instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability<IAcceleratorTube> capability, IAcceleratorTube instance, EnumFacing side, NBTBase nbt) {
            }
        }, () -> null);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        proxyLoader.init();
        ArmorRadiationHandler.getArmorRadData(new ItemStack((Item)Items.field_151027_R), true).addRadiationLevel(new ArmorRadLevelData(0.0f).setProtectionFlat(20.0f).setTranslationKey("atomicscience::basic"));
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxyLoader.postInit();
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        proxyLoader.loadComplete();
    }

    @Mod.EventHandler
    public void serverAboutToStart(FMLServerAboutToStartEvent event) {
        MapHandler.THREAD_RAD_EXPOSURE = new ThreadRadExposure();
        MapHandler.THREAD_RAD_EXPOSURE.start();
        MapHandler.THREAD_THERMAL_ACTION = new ThreadThermalAction();
        MapHandler.THREAD_THERMAL_ACTION.start();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        ICommandManager commandManager = FMLCommonHandler.instance().getMinecraftServerInstance().func_71187_D();
        ServerCommandManager serverCommandManager = (ServerCommandManager)commandManager;
        serverCommandManager.func_71560_a((ICommand)new CommandAS());
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        MapHandler.THREAD_RAD_EXPOSURE.kill();
        MapHandler.THREAD_THERMAL_ACTION.kill();
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(DOMAIN)) {
            ConfigManager.sync((String)DOMAIN, (Config.Type)Config.Type.INSTANCE);
        }
    }

    static {
        logger = LogManager.getLogger((String)DOMAIN);
        runningAsDev = System.getProperty("development") != null && System.getProperty("development").equalsIgnoreCase("true");
    }
}

