/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.gui;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.ndrei.teslacorelib.gui.BasicContainerGuiPiece;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.FluidTankPiece;
import net.ndrei.teslacorelib.inventory.FluidTankType;
import net.ndrei.teslacorelib.inventory.IFluidTankWrapper;
import net.ndrei.teslacorelib.inventory.ITypedFluidTank;
import net.ndrei.teslacorelib.localization.LocalizationKt;
import net.ndrei.teslacorelib.localization.LocalizedModText;
import net.ndrei.teslacorelib.tileentities.SidedTileEntity;
import net.ndrei.teslacorelib.utils.FluidextensionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ<\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tH\u0016J4\u0010\u0016\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tH\u0016J,\u0010\u0017\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lnet/ndrei/teslacorelib/gui/FluidTankPiece;", "Lnet/ndrei/teslacorelib/gui/BasicContainerGuiPiece;", "tile", "Lnet/ndrei/teslacorelib/tileentities/SidedTileEntity;", "color", "Lnet/minecraft/item/EnumDyeColor;", "tank", "Lnet/minecraftforge/fluids/IFluidTank;", "left", "", "top", "(Lnet/ndrei/teslacorelib/tileentities/SidedTileEntity;Lnet/minecraft/item/EnumDyeColor;Lnet/minecraftforge/fluids/IFluidTank;II)V", "drawBackgroundLayer", "", "container", "Lnet/ndrei/teslacorelib/gui/BasicTeslaGuiContainer;", "guiX", "guiY", "partialTicks", "", "mouseX", "mouseY", "drawForegroundTopLayer", "mouseClicked", "mouseButton", "Companion", "tesla-core-lib"})
public final class FluidTankPiece
extends BasicContainerGuiPiece {
    private final SidedTileEntity tile;
    private final EnumDyeColor color;
    private final IFluidTank tank;
    private static final int WIDTH = 18;
    private static final int HEIGHT = 54;
    public static final Companion Companion = new Companion(null);

    @Override
    public void drawBackgroundLayer(@NotNull BasicTeslaGuiContainer<?> container, int guiX, int guiY, float partialTicks, int mouseX, int mouseY) {
        Intrinsics.checkParameterIsNotNull(container, (String)"container");
        container.bindDefaultTexture();
        container.drawTexturedRect(this.getLeft(), this.getTop(), 1, 189, this.getWidth(), this.getHeight());
        container.drawTexturedRect(this.getLeft() + 2, this.getTop() + 2, 48, 191, this.getWidth() - 4, this.getHeight() - 4);
        FluidStack stack = this.tank.getFluid();
        if (stack != null && stack.amount > 0) {
            int amount = stack.amount * (this.getHeight() - 6) / this.tank.getCapacity();
            if (stack.getFluid() != null) {
                Fluid fluid = stack.getFluid();
                int color = fluid.getColor(stack);
                ResourceLocation still = fluid.getFlowing(stack);
                if (still != null) {
                    Minecraft minecraft = container.field_146297_k;
                    Intrinsics.checkExpressionValueIsNotNull((Object)minecraft, (String)"container.mc");
                    TextureAtlasSprite sprite = minecraft.func_147117_R().getTextureExtry(still.toString());
                    if (sprite == null) {
                        Minecraft minecraft2 = container.field_146297_k;
                        Intrinsics.checkExpressionValueIsNotNull((Object)minecraft2, (String)"container.mc");
                        TextureMap textureMap = minecraft2.func_147117_R();
                        Intrinsics.checkExpressionValueIsNotNull((Object)textureMap, (String)"container.mc.textureMapBlocks");
                        sprite = textureMap.func_174944_f();
                    }
                    Minecraft minecraft3 = container.field_146297_k;
                    Intrinsics.checkExpressionValueIsNotNull((Object)minecraft3, (String)"container.mc");
                    minecraft3.func_110434_K().func_110577_a(TextureMap.field_110575_b);
                    GlStateManager.func_179131_c((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24 & 0xFF) / 255.0f));
                    GlStateManager.func_179147_l();
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    int n = guiX + this.getLeft() + 3;
                    int n2 = guiY + this.getTop() + 3;
                    Fluid fluid2 = fluid;
                    Intrinsics.checkExpressionValueIsNotNull((Object)fluid2, (String)"fluid");
                    int n3 = n2 + (fluid2.isGaseous() ? 0 : this.getHeight() - 6 - amount);
                    TextureAtlasSprite textureAtlasSprite = sprite;
                    if (textureAtlasSprite == null) {
                        Intrinsics.throwNpe();
                    }
                    container.func_175175_a(n, n3, textureAtlasSprite, this.getWidth() - 6, amount);
                    GlStateManager.func_179084_k();
                }
            }
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        container.bindDefaultTexture();
        container.drawTexturedRect(this.getLeft() + 2, this.getTop() + 2, 63, 191, this.getWidth() - 4, this.getHeight() - 4);
    }

    @Override
    public void drawForegroundTopLayer(@NotNull BasicTeslaGuiContainer<?> container, int guiX, int guiY, int mouseX, int mouseY) {
        Intrinsics.checkParameterIsNotNull(container, (String)"container");
        if (super.isInside(container, mouseX, mouseY)) {
            ItemStack stack;
            FluidStack fluid = this.tank.getFluid();
            List lines2 = CollectionsKt.mutableListOf((Object[])new String[]{LocalizationKt.localizeModString("teslacorelib", "fluid tank", "fluid", (Function1<? super LocalizedModText, Unit>)((Function1)new Function1<LocalizedModText, Unit>(fluid){
                final /* synthetic */ FluidStack $fluid;

                public final void invoke(@NotNull LocalizedModText $receiver) {
                    ITextComponent iTextComponent;
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    $receiver.unaryPlus(TextFormatting.DARK_PURPLE);
                    if (this.$fluid == null) {
                        iTextComponent = LocalizationKt.localizeModString("teslacorelib", "fluid tank", "fluid_empty", (Function1<? super LocalizedModText, Unit>)((Function1)drawForegroundTopLayer.lines.1.INSTANCE));
                    } else {
                        String string = this.$fluid.getLocalizedName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fluid.localizedName");
                        iTextComponent = LocalizationKt.makeTextComponent(string, TextFormatting.LIGHT_PURPLE);
                    }
                    $receiver.unaryPlus(iTextComponent);
                }
                {
                    this.$fluid = fluidStack;
                    super(1);
                }
            })).func_150254_d(), LocalizationKt.localizeModString("teslacorelib", "fluid tank", "fluid_amount", (Function1<? super LocalizedModText, Unit>)((Function1)new Function1<LocalizedModText, Unit>(this){
                final /* synthetic */ FluidTankPiece this$0;

                public final void invoke(@NotNull LocalizedModText $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    $receiver.unaryPlus(TextFormatting.DARK_GRAY);
                    $receiver.unaryPlus(LocalizationKt.localizeFluidAmount(FluidTankPiece.access$getTank$p(this.this$0).getFluidAmount(), TextFormatting.AQUA));
                    $receiver.unaryPlus(LocalizationKt.localizeFluidAmount(FluidTankPiece.access$getTank$p(this.this$0).getCapacity(), TextFormatting.DARK_AQUA));
                }
                {
                    this.this$0 = fluidTankPiece;
                    super(1);
                }
            })).func_150254_d()});
            InventoryPlayer inventoryPlayer = container.field_146297_k.field_71439_g.field_71071_by;
            Intrinsics.checkExpressionValueIsNotNull((Object)inventoryPlayer, (String)"container.mc.player.inventory");
            ItemStack itemStack = stack = inventoryPlayer.func_70445_o();
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
            if (!itemStack.func_190926_b()) {
                FluidStack bucket = FluidextensionsKt.getContainedFluid(stack);
                lines2.add(LocalizationKt.localizeModString("teslacorelib", "fluid tank", "hovering with", (Function1<? super LocalizedModText, Unit>)((Function1)new Function1<LocalizedModText, Unit>(bucket, stack){
                    final /* synthetic */ FluidStack $bucket;
                    final /* synthetic */ ItemStack $stack;

                    public final void invoke(@NotNull LocalizedModText $receiver) {
                        ITextComponent iTextComponent;
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        $receiver.unaryPlus(TextFormatting.BLUE);
                        FluidStack fluidStack = this.$bucket;
                        if ((fluidStack != null ? fluidStack.getFluid() : null) == null) {
                            StringBuilder stringBuilder = new StringBuilder();
                            ItemStack itemStack = this.$stack;
                            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
                            iTextComponent = LocalizationKt.localizeModString(stringBuilder.append(itemStack.func_77977_a()).append(".name").toString(), (Function1<? super LocalizedModText, Unit>)((Function1)drawForegroundTopLayer.1.INSTANCE));
                        } else {
                            String string = this.$bucket.getLocalizedName();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"bucket.localizedName");
                            iTextComponent = LocalizationKt.makeTextComponent(string, TextFormatting.AQUA);
                        }
                        $receiver.unaryPlus(iTextComponent);
                    }
                    {
                        this.$bucket = fluidStack;
                        this.$stack = itemStack;
                        super(1);
                    }
                })).func_150254_d());
                if (bucket != null) {
                    if (FluidextensionsKt.canFillFrom(this.tank, stack)) {
                        lines2.add(LocalizationKt.localizeModString("teslacorelib", "fluid tank", "accepting fluid", (Function1<? super LocalizedModText, Unit>)((Function1)drawForegroundTopLayer.2.INSTANCE)).func_150254_d());
                    } else {
                        lines2.add(LocalizationKt.localizeModString("teslacorelib", "fluid tank", "not accepting fluid", (Function1<? super LocalizedModText, Unit>)((Function1)drawForegroundTopLayer.3.INSTANCE)).func_150254_d());
                    }
                }
                IFluidTank iFluidTank = this.tank;
                ItemStack itemStack2 = stack;
                IFluidTank it = iFluidTank;
                IFluidTank iFluidTank2 = it instanceof ITypedFluidTank && it instanceof IFluidTankWrapper && ((ITypedFluidTank)it).getTankType() == FluidTankType.INPUT ? ((IFluidTankWrapper)it).getInnerTank() : it;
                IFluidTank iFluidTank3 = iFluidTank2;
                if (FluidextensionsKt.canFillFrom(itemStack2, iFluidTank3)) {
                    lines2.add(LocalizationKt.localizeModString("teslacorelib", "fluid tank", "can fill from container", (Function1<? super LocalizedModText, Unit>)((Function1)drawForegroundTopLayer.5.INSTANCE)).func_150254_d());
                }
            }
            container.drawTooltip(lines2, mouseX - guiX, mouseY - guiY);
        }
    }

    @Override
    public void mouseClicked(@NotNull BasicTeslaGuiContainer<?> container, int mouseX, int mouseY, int mouseButton) {
        Intrinsics.checkParameterIsNotNull(container, (String)"container");
        super.mouseClicked(container, mouseX, mouseY, mouseButton);
        if (super.isInside(container, mouseX, mouseY)) {
            ItemStack stack;
            InventoryPlayer inventoryPlayer = container.field_146297_k.field_71439_g.field_71071_by;
            Intrinsics.checkExpressionValueIsNotNull((Object)inventoryPlayer, (String)"container.mc.player.inventory");
            ItemStack itemStack = stack = inventoryPlayer.func_70445_o();
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
            if (!itemStack.func_190926_b()) {
                FluidStack bucket = FluidextensionsKt.getContainedFluid(stack);
                boolean canFill = bucket != null && FluidextensionsKt.canFillFrom(this.tank, stack);
                IFluidTank iFluidTank = this.tank;
                ItemStack itemStack2 = stack;
                IFluidTank it = iFluidTank;
                IFluidTank iFluidTank2 = it instanceof ITypedFluidTank && it instanceof IFluidTankWrapper && ((ITypedFluidTank)it).getTankType() == FluidTankType.INPUT ? ((IFluidTankWrapper)it).getInnerTank() : it;
                boolean canDrain = FluidextensionsKt.canFillFrom(itemStack2, iFluidTank2);
                if (canFill || canDrain) {
                    String string;
                    if (mouseButton == 0 && canFill) {
                        string = "FILL_TANK";
                    } else if (mouseButton == 1 && canDrain) {
                        string = "DRAIN_TANK";
                    } else {
                        return;
                    }
                    String action = string;
                    NBTTagCompound nbt = this.tile.setupSpecialNBTMessage(action);
                    nbt.func_74782_a("stack", (NBTBase)stack.func_77955_b(new NBTTagCompound()));
                    nbt.func_74768_a("color", this.color.func_176765_a());
                    this.tile.sendToServer(nbt);
                }
            }
        }
    }

    public FluidTankPiece(@NotNull SidedTileEntity tile, @NotNull EnumDyeColor color, @NotNull IFluidTank tank2, int left, int top) {
        Intrinsics.checkParameterIsNotNull((Object)tile, (String)"tile");
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        Intrinsics.checkParameterIsNotNull((Object)tank2, (String)"tank");
        super(left, top, WIDTH, HEIGHT);
        this.tile = tile;
        this.color = color;
        this.tank = tank2;
    }

    static {
        WIDTH = 18;
        HEIGHT = 54;
    }

    @NotNull
    public static final /* synthetic */ IFluidTank access$getTank$p(FluidTankPiece $this) {
        return $this.tank;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lnet/ndrei/teslacorelib/gui/FluidTankPiece$Companion;", "", "()V", "HEIGHT", "", "getHEIGHT", "()I", "WIDTH", "getWIDTH", "tesla-core-lib"})
    public static final class Companion {
        public final int getWIDTH() {
            return WIDTH;
        }

        public final int getHEIGHT() {
            return HEIGHT;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

