/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.common.tile.reactor;

import igentuman.bfr.common.tile.reactor.TileEntityReactorBlock;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import mekanism.api.TileNetworkList;
import mekanism.common.integration.computer.IComputerIntegration;
import mekanism.common.util.LangUtils;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityReactorLogicAdapter
extends TileEntityReactorBlock
implements IComputerIntegration {
    private static final String[] methods = new String[]{"isIgnited", "canIgnite", "getPlasmaHeat", "getMaxPlasmaHeat", "getCaseHeat", "getMaxCaseHeat", "getInjectionRate", "setInjectionRate", "hasFuel", "getProducing", "getIgnitionTemp", "getEnergy", "getMaxEnergy", "getWater", "getSteam", "getFuel", "getDeuterium", "getTritium", "getEfficiency", "getErrorLevel", "adjustReactivity"};
    public ReactorLogic logicType = ReactorLogic.READY;
    public boolean activeCooled;
    public int prevRedstoneLevel;
    int prevInputRedstone = 0;

    public TileEntityReactorLogicAdapter() {
        this.fullName = "ReactorLogicAdapter";
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            int outputting = this.getRedstoneLevel();
            if (outputting != this.prevRedstoneLevel) {
                this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q(), true);
            }
            this.prevRedstoneLevel = outputting;
            int redstone = this.field_145850_b.func_175687_A(this.func_174877_v());
            if (this.prevInputRedstone > 0) {
                this.prevInputRedstone = redstone;
                return;
            }
            this.prevInputRedstone = redstone;
            if (this.getReactor() != null && redstone > 0) {
                switch (this.logicType) {
                    case INJECTION_UP: {
                        this.getReactor().setInjectionRate(this.getReactor().getInjectionRate() + 2);
                        break;
                    }
                    case INJECTION_DOWN: {
                        this.getReactor().setInjectionRate(this.getReactor().getInjectionRate() - 2);
                        break;
                    }
                    case REACTIVITY_UP: {
                        this.getReactor().adjustReactivity(redstone);
                        break;
                    }
                    case REACTIVITY_DOWN: {
                        this.getReactor().adjustReactivity(-redstone);
                    }
                }
            }
        }
    }

    @Override
    public boolean isFrame() {
        return false;
    }

    public int getRedstoneLevel() {
        if (this.field_145850_b.field_72995_K) {
            return this.prevRedstoneLevel;
        }
        if (this.getReactor() == null || !this.getReactor().isFormed()) {
            return 0;
        }
        switch (this.logicType) {
            case READY: {
                return this.getReactor().getPlasmaTemp() >= this.getReactor().getIgnitionTemperature(this.activeCooled) ? 15 : 0;
            }
            case CAPACITY: {
                return this.getReactor().getPlasmaTemp() >= this.getReactor().getMaxPlasmaTemperature(this.activeCooled) ? 15 : 0;
            }
            case ERROR_LEVEL: {
                return (int)(this.getReactor().getErrorLevel() / 6.0f);
            }
            case EFFICIENCY: {
                return (int)(this.getReactor().getEfficiency() / 6.0f);
            }
            case DEPLETED: {
                return this.getReactor().getDeuteriumTank().getStored() < this.getReactor().getInjectionRate() / 2 || this.getReactor().getTritiumTank().getStored() < this.getReactor().getInjectionRate() / 2 ? 15 : 0;
            }
        }
        return 0;
    }

    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.logicType = ReactorLogic.values()[nbtTags.func_74762_e("logicType")];
        this.activeCooled = nbtTags.func_74767_n("activeCooled");
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("logicType", this.logicType.ordinal());
        nbtTags.func_74757_a("activeCooled", this.activeCooled);
        return nbtTags;
    }

    public void handlePacketData(ByteBuf dataStream) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int type = dataStream.readInt();
            if (type == 0) {
                this.activeCooled = !this.activeCooled;
            } else if (type == 1) {
                this.logicType = ReactorLogic.values()[dataStream.readInt()];
            }
            return;
        }
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.logicType = ReactorLogic.values()[dataStream.readInt()];
            this.activeCooled = dataStream.readBoolean();
            this.prevRedstoneLevel = dataStream.readInt();
        }
    }

    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add((Object)this.logicType.ordinal());
        data.add((Object)this.activeCooled);
        data.add((Object)this.prevRedstoneLevel);
        return data;
    }

    public String[] getMethods() {
        return methods;
    }

    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        if (this.getReactor() == null || !this.getReactor().isFormed()) {
            return new Object[]{"Unformed."};
        }
        switch (method) {
            case 0: {
                return new Object[]{this.getReactor().isBurning()};
            }
            case 1: {
                return new Object[]{this.getReactor().getPlasmaTemp() >= this.getReactor().getIgnitionTemperature(this.activeCooled)};
            }
            case 2: {
                return new Object[]{this.getReactor().getPlasmaTemp()};
            }
            case 3: {
                return new Object[]{this.getReactor().getMaxPlasmaTemperature(this.activeCooled)};
            }
            case 4: {
                return new Object[]{this.getReactor().getCaseTemp()};
            }
            case 5: {
                return new Object[]{this.getReactor().getMaxCasingTemperature(this.activeCooled)};
            }
            case 6: {
                return new Object[]{this.getReactor().getInjectionRate()};
            }
            case 7: {
                if (arguments[0] instanceof Double) {
                    this.getReactor().setInjectionRate(((Double)arguments[0]).intValue());
                    return new Object[]{"Injection rate set."};
                }
                return new Object[]{"Invalid parameters."};
            }
            case 8: {
                return new Object[]{this.getReactor().getDeuteriumTank().getStored() >= this.getReactor().getInjectionRate() / 2 && this.getReactor().getTritiumTank().getStored() >= this.getReactor().getInjectionRate() / 2};
            }
            case 9: {
                return new Object[]{this.getReactor().getPassiveGeneration(false, true)};
            }
            case 10: {
                return new Object[]{this.getReactor().getIgnitionTemperature(this.activeCooled)};
            }
            case 11: {
                return new Object[]{this.getReactor().getBufferedEnergy()};
            }
            case 12: {
                return new Object[]{this.getReactor().getBufferSize()};
            }
            case 13: {
                return new Object[]{this.getReactor().getWaterTank().getFluidAmount()};
            }
            case 14: {
                return new Object[]{this.getReactor().getSteamTank().getFluidAmount()};
            }
            case 15: {
                return new Object[]{this.getReactor().getFuelTank().getStored()};
            }
            case 16: {
                return new Object[]{this.getReactor().getDeuteriumTank().getStored()};
            }
            case 17: {
                return new Object[]{this.getReactor().getTritiumTank().getStored()};
            }
            case 18: {
                return new Object[]{Float.valueOf(this.getReactor().getEfficiency())};
            }
            case 19: {
                return new Object[]{Float.valueOf(this.getReactor().getErrorLevel())};
            }
            case 20: {
                return new Object[]{this.getReactor().adjustReactivity(((Double)arguments[0]).floatValue())};
            }
        }
        throw new NoSuchMethodException();
    }

    public static enum ReactorLogic {
        READY("ready", new ItemStack(Items.field_151137_ax), "out"),
        CAPACITY("capacity", new ItemStack(Items.field_151137_ax), "out"),
        DEPLETED("depleted", new ItemStack(Items.field_151137_ax), "out"),
        ERROR_LEVEL("error_level", new ItemStack(Items.field_151137_ax), "out"),
        EFFICIENCY("efficiency", new ItemStack(Items.field_151137_ax), "out"),
        REACTIVITY_UP("reactivity_up", new ItemStack(Items.field_151137_ax), "in"),
        REACTIVITY_DOWN("reactivity_down", new ItemStack(Items.field_151137_ax), "in"),
        INJECTION_UP("injection_up", new ItemStack(Items.field_151137_ax), "in"),
        INJECTION_DOWN("injection_down", new ItemStack(Items.field_151137_ax), "in");

        private String name;
        private ItemStack renderStack;
        private String direction;

        private ReactorLogic(String s, ItemStack stack, String dir) {
            this.name = s;
            this.renderStack = stack;
            this.direction = dir;
        }

        public ItemStack getRenderStack() {
            return this.renderStack;
        }

        public String getDirection() {
            return this.direction;
        }

        public String getLocalizedName() {
            return LangUtils.localize((String)("reactor." + this.name));
        }

        public String getDescription() {
            return LangUtils.localize((String)("reactor." + this.name + ".desc"));
        }
    }
}

