/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.common.tile.reactor;

import igentuman.bfr.common.BetterFusionReactor;
import igentuman.bfr.common.tile.reactor.TileEntityReactorController;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.common.tile.prefab.TileEntityElectricBlock;
import mekanism.common.util.InventoryUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class TileEntityReactorBlock
extends TileEntityElectricBlock {
    public BetterFusionReactor fusionReactor;
    public boolean attempted;
    public boolean changed;

    public TileEntityReactorBlock() {
        super("ReactorBlock", 0.0);
        this.inventory = NonNullList.func_191197_a((int)0, (Object)ItemStack.field_190927_a);
    }

    public TileEntityReactorBlock(String name, double maxEnergy) {
        super(name, maxEnergy);
    }

    public abstract boolean isFrame();

    public BetterFusionReactor getReactor() {
        return this.fusionReactor;
    }

    public void setReactor(BetterFusionReactor reactor) {
        if (reactor != this.fusionReactor) {
            this.changed = true;
        }
        this.fusionReactor = reactor;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.getReactor() != null) {
            this.getReactor().formMultiblock(false);
        }
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.changed) {
            this.changed = false;
        }
        if (!(this.field_145850_b.field_72995_K || this.ticker != 5 || this.attempted || this.getReactor() != null && this.getReactor().isFormed())) {
            this.updateController();
        }
        this.attempted = false;
    }

    public boolean sideIsOutput(EnumFacing side) {
        return false;
    }

    public boolean sideIsConsumer(EnumFacing side) {
        return false;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (!(this instanceof TileEntityReactorController) && this.getReactor() != null) {
            this.getReactor().formMultiblock(true);
        }
    }

    public void onAdded() {
        super.onAdded();
        if (!this.field_145850_b.field_72995_K) {
            if (this.getReactor() != null) {
                this.getReactor().formMultiblock(false);
            } else {
                this.updateController();
            }
        }
    }

    public void updateController() {
        TileEntityReactorController found;
        if (!(this instanceof TileEntityReactorController || (found = new ControllerFinder().find()) == null || found.getReactor() != null && found.getReactor().isFormed())) {
            found.formMultiblock(false);
        }
    }

    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return InventoryUtils.EMPTY;
    }

    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.isCapabilityDisabled(capability, side);
    }

    public class ControllerFinder {
        public TileEntityReactorController found;
        public Set<Coord4D> iterated = new HashSet<Coord4D>();

        public void loop(Coord4D pos) {
            if (this.iterated.size() > 512 || this.found != null) {
                return;
            }
            this.iterated.add(pos);
            for (EnumFacing side : EnumFacing.field_82609_l) {
                Coord4D coord = pos.offset(side);
                if (this.iterated.contains(coord) || !(coord.getTileEntity((IBlockAccess)TileEntityReactorBlock.this.field_145850_b) instanceof TileEntityReactorBlock)) continue;
                ((TileEntityReactorBlock)coord.getTileEntity((IBlockAccess)((TileEntityReactorBlock)TileEntityReactorBlock.this).field_145850_b)).attempted = true;
                if (coord.getTileEntity((IBlockAccess)TileEntityReactorBlock.this.field_145850_b) instanceof TileEntityReactorController) {
                    this.found = (TileEntityReactorController)coord.getTileEntity((IBlockAccess)TileEntityReactorBlock.this.field_145850_b);
                    return;
                }
                this.loop(coord);
            }
        }

        public TileEntityReactorController find() {
            this.loop(Coord4D.get((TileEntity)TileEntityReactorBlock.this));
            return this.found;
        }
    }
}

