/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.common.recipes;

import igentuman.bfr.common.recipes.ReactorCoolantRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;

public class RecipeManager<T extends ReactorCoolantRecipe> {
    private final List<T> recipes;
    private List<Fluid> allowedInputs;
    private List<Fluid> allowedOutputs;

    public RecipeManager() {
        this.recipes = new ArrayList<T>();
    }

    public RecipeManager(int size) {
        this.recipes = new ArrayList<T>(size);
    }

    public void add(T recipe) {
        this.recipes.add(recipe);
    }

    @Nullable
    @Deprecated
    public T get(Object ... inputs) {
        return (T)((ReactorCoolantRecipe)this.recipes.stream().filter(x -> x.test(inputs)).findFirst().orElse(null));
    }

    @Nullable
    public T get(Object input) {
        return (T)((ReactorCoolantRecipe)this.recipes.stream().filter(x -> x.test(input)).findFirst().orElse(null));
    }

    @Nonnull
    public List<T> getAll() {
        return Collections.unmodifiableList(this.recipes);
    }

    public List<Fluid> getAllowedInputs() {
        if (this.allowedInputs == null) {
            this.allowedInputs = new ArrayList<Fluid>();
            for (ReactorCoolantRecipe recipe : this.getAll()) {
                this.allowedInputs.add(recipe.getInput().getFluidStacks().get(0).getFluid());
            }
        }
        return this.allowedInputs;
    }

    public List<Fluid> getAllowedOutputs() {
        if (this.allowedOutputs == null) {
            this.allowedOutputs = new ArrayList<Fluid>();
            for (ReactorCoolantRecipe recipe : this.getAll()) {
                this.allowedOutputs.add(recipe.getOutput().getFluid());
            }
        }
        return this.allowedOutputs;
    }

    @Deprecated
    public void remove(Object ... inputs) {
        this.recipes.removeIf(x -> x.matches(inputs));
    }

    public void remove(Object input) {
        this.recipes.removeIf(x -> x.matches(input));
    }
}

