/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.common.recipes;

import igentuman.bfr.common.recipes.IRecipeIngredient;
import igentuman.bfr.common.recipes.StackHelper;
import javax.annotation.Nonnull;
import net.minecraftforge.fluids.FluidStack;

public class ReactorCoolantRecipe {
    protected final IRecipeIngredient ingredient;
    protected final FluidStack outputStack;
    protected final int inputAmount;

    public ReactorCoolantRecipe(FluidStack outputStack, FluidStack inputStack) {
        this.outputStack = outputStack;
        this.inputAmount = inputStack.amount == 0 ? 0 : inputStack.amount;
        this.ingredient = IRecipeIngredient.of(inputStack);
    }

    public boolean test(Object input) {
        return this.ingredient.test(input);
    }

    @Deprecated
    public boolean test(Object ... inputs) {
        throw new UnsupportedOperationException("This recipe does not support access by multiple inputs");
    }

    public boolean matches(Object input) {
        return input instanceof IRecipeIngredient && this.ingredient.matches((IRecipeIngredient)input);
    }

    @Deprecated
    public boolean matches(Object ... inputs) {
        throw new UnsupportedOperationException("This recipe does not support access by multiple inputs");
    }

    public FluidStack consumeInput(FluidStack stack) {
        return StackHelper.consumeFluid(stack, this.inputAmount);
    }

    @Nonnull
    public FluidStack getOutput() {
        return this.outputStack.copy();
    }

    public IRecipeIngredient getInput() {
        return this.ingredient;
    }

    public String getName() {
        return this.ingredient.getName();
    }
}

