/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.common.recipes;

import igentuman.bfr.common.recipes.IRecipeIngredient;
import igentuman.bfr.common.recipes.StackHelper;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.fluids.FluidStack;

public class IngredientIFluidStack
implements IRecipeIngredient {
    protected final FluidStack stack;
    private final List<FluidStack> stacks;

    IngredientIFluidStack(@Nonnull FluidStack stack) {
        this.stack = stack;
        this.stacks = Collections.singletonList(stack);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.stack.getLocalizedName();
    }

    @Override
    @Nonnull
    public List<FluidStack> getFluidStacks() {
        return this.stacks;
    }

    @Override
    public boolean test(Object obj) {
        return this.testIgnoreCount(obj) && ((FluidStack)obj).amount >= this.stack.amount;
    }

    @Override
    public boolean testIgnoreCount(Object obj) {
        return obj instanceof FluidStack && StackHelper.doFluidStacksMatch(this.stack, (FluidStack)obj);
    }

    @Override
    public boolean matches(IRecipeIngredient other) {
        return other instanceof IngredientIFluidStack && StackHelper.doFluidStacksMatch(this.stack, ((IngredientIFluidStack)other).stack);
    }
}

