/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.common.recipes;

import com.google.common.collect.Lists;
import igentuman.bfr.common.config.ReactorCoolantRecipesConfig;
import igentuman.bfr.common.recipes.ReactorCoolantRecipe;
import igentuman.bfr.common.recipes.RecipeManager;
import igentuman.bfr.common.recipes.StackHelper;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mekanism.generators.common.GeneratorsBlocks;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BFRRecipes {
    private static boolean initialized = false;
    public static final RecipeManager<ReactorCoolantRecipe> REACTOR_COOLANT = new RecipeManager();
    private static final Map<String, Integer> RECIPE_COUNT_MAP = new HashMap<String, Integer>();

    @SubscribeEvent(priority=EventPriority.LOW)
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        if (initialized) {
            return;
        }
        BFRRecipes.removeRecipeFor(Item.func_150898_a((Block)GeneratorsBlocks.Reactor), 0);
        BFRRecipes.removeRecipeFor(Item.func_150898_a((Block)GeneratorsBlocks.Reactor), 1);
        BFRRecipes.removeRecipeFor(Item.func_150898_a((Block)GeneratorsBlocks.Reactor), 2);
        BFRRecipes.removeRecipeFor(Item.func_150898_a((Block)GeneratorsBlocks.Reactor), 3);
        BFRRecipes.removeRecipeFor(Item.func_150898_a((Block)GeneratorsBlocks.ReactorGlass), 0);
        BFRRecipes.removeRecipeFor(Item.func_150898_a((Block)GeneratorsBlocks.ReactorGlass), 1);
        for (ReactorCoolantRecipe recipe : ReactorCoolantRecipesConfig.getReactorCoolantRecipes()) {
            REACTOR_COOLANT.add(recipe);
        }
        initialized = true;
    }

    public static void removeRecipeFor(Item item, int meta) {
        ForgeRegistry recipeRegistry = (ForgeRegistry)ForgeRegistries.RECIPES;
        ArrayList recipes = Lists.newArrayList((Iterable)recipeRegistry.getValues());
        for (IRecipe r : recipes) {
            ItemStack output = r.func_77571_b();
            if (output.func_77973_b() != item || output.func_77973_b().getMetadata(output) != meta) continue;
            recipeRegistry.remove(r.getRegistryName());
        }
    }

    public static void addShapedOreRecipe(Object out, Object ... inputs) {
        BFRRecipes.registerRecipe(ShapedOreRecipe.class, out, inputs);
    }

    public static <T> T newInstance(Class<T> clazz, Object ... args) throws Exception {
        Constructor<T> constructor = clazz.getConstructor(BFRRecipes.getClasses(args));
        return constructor.newInstance(args);
    }

    public static Class<?>[] getClasses(Object ... objects) {
        Class[] classes = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            classes[i] = objects[i].getClass();
        }
        return classes;
    }

    public static void registerRecipe(Class<? extends IRecipe> clazz, Object out, Object ... inputs) {
        if (out == null || Lists.newArrayList((Object[])inputs).contains(null)) {
            return;
        }
        ItemStack outStack = StackHelper.fixItemStack(out);
        if (!outStack.func_190926_b() && inputs != null) {
            String outName = outStack.func_77977_a();
            if (RECIPE_COUNT_MAP.containsKey(outName)) {
                int count = RECIPE_COUNT_MAP.get(outName);
                RECIPE_COUNT_MAP.put(outName, count + 1);
                outName = outName + "_" + count;
            } else {
                RECIPE_COUNT_MAP.put(outName, 1);
            }
            ResourceLocation location = new ResourceLocation("bfr", outName);
            try {
                IRecipe recipe = BFRRecipes.newInstance(clazz, location, outStack, inputs);
                recipe.setRegistryName(location);
                ForgeRegistries.RECIPES.register((IForgeRegistryEntry)recipe);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

