/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.common.integration.jei;

import com.google.common.collect.ImmutableList;
import igentuman.bfr.common.recipes.ReactorCoolantRecipe;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
public class ReactorCoolantRecipeCategory
implements IRecipeCategory<Wrapper>,
ITooltipCallback<FluidStack> {
    private static final ResourceLocation GUI_LOCATION = new ResourceLocation("bfr", "textures/gui/jei/reactor_coolant.png");
    private static final String TRANSLATION_KEY = "bfr.jei.category.reactor_coolant";
    private final IDrawable background;
    private final IDrawableAnimated animatedArrow;

    public ReactorCoolantRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GUI_LOCATION, 0, 0, 74, 20);
        IDrawableStatic staticArrow = guiHelper.createDrawable(GUI_LOCATION, 0, 20, 26, 20);
        this.animatedArrow = guiHelper.createAnimatedDrawable(staticArrow, 200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    @Nonnull
    public String getUid() {
        return "bfr_reactor_coolant";
    }

    @Nonnull
    public String getTitle() {
        return I18n.func_135052_a((String)TRANSLATION_KEY, (Object[])new Object[0]);
    }

    @Nonnull
    public String getModName() {
        return "bfr";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void drawExtras(Minecraft minecraft) {
        this.animatedArrow.draw(minecraft, 25, 2);
    }

    public void setRecipe(IRecipeLayout recipeLayout, Wrapper wrapper, IIngredients ingredients) {
        int index = 0;
        recipeLayout.getFluidStacks().init(index, true, 1, 1);
        recipeLayout.getFluidStacks().set(index, (List)ingredients.getInputs(FluidStack.class).get(0));
        recipeLayout.getFluidStacks().init(++index, false, 57, 1);
        recipeLayout.getFluidStacks().set(index, (List)ingredients.getOutputs(FluidStack.class).get(0));
        recipeLayout.getFluidStacks().addTooltipCallback((ITooltipCallback)this);
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return Collections.emptyList();
    }

    public void onTooltip(int slotIndex, boolean input, FluidStack ingredient, List<String> tooltip) {
        String last = tooltip.get(tooltip.size() - 1);
        tooltip.remove(tooltip.size() - 1);
        tooltip.add(TextFormatting.YELLOW + String.valueOf(ingredient.amount) + " mB");
        if (!input) {
            tooltip.add(TextFormatting.AQUA + I18n.func_135052_a((String)"bfr.jei.coolant_title", (Object[])new Object[0]));
        }
        tooltip.add(last);
    }

    public static class Wrapper
    implements IRecipeWrapper {
        private final List<List<FluidStack>> input;
        private final List<List<FluidStack>> output;

        public Wrapper(ReactorCoolantRecipe recipe) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add(recipe.getInput().getFluidStacks());
            this.input = builder.build();
            builder = ImmutableList.builder();
            builder.add((Object)ImmutableList.of((Object)recipe.getOutput()));
            this.output = builder.build();
        }

        public void getIngredients(@Nonnull IIngredients ingredients) {
            ingredients.setInputLists(FluidStack.class, this.input);
            ingredients.setOutputLists(FluidStack.class, this.output);
        }
    }
}

