/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.common.block.states;

import com.google.common.base.Predicate;
import igentuman.bfr.common.BFRBlocks;
import igentuman.bfr.common.block.BlockReactor;
import igentuman.bfr.common.tile.reactor.TileEntityReactorController;
import igentuman.bfr.common.tile.reactor.TileEntityReactorFrame;
import igentuman.bfr.common.tile.reactor.TileEntityReactorGlass;
import igentuman.bfr.common.tile.reactor.TileEntityReactorLaserFocusMatrix;
import igentuman.bfr.common.tile.reactor.TileEntityReactorLogicAdapter;
import igentuman.bfr.common.tile.reactor.TileEntityReactorPort;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.common.tile.prefab.TileEntityElectricBlock;
import mekanism.common.util.LangUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockStateReactor
extends ExtendedBlockState {
    public static final PropertyBool activeProperty = PropertyBool.func_177716_a((String)"active");

    public BlockStateReactor(BlockReactor block, PropertyEnum<ReactorBlockType> typeProperty) {
        super((Block)block, new IProperty[]{typeProperty, activeProperty}, new IUnlistedProperty[0]);
    }

    public static class ReactorBlockStateMapper
    extends StateMapperBase {
        @Nonnull
        protected ModelResourceLocation func_178132_a(@Nonnull IBlockState state) {
            BlockReactor block = (BlockReactor)state.func_177230_c();
            ReactorBlockType type = (ReactorBlockType)((Object)state.func_177229_b(block.getTypeProperty()));
            StringBuilder builder = new StringBuilder();
            String nameOverride = null;
            if (type.hasActiveTexture()) {
                builder.append(activeProperty.func_177701_a());
                builder.append("=");
                builder.append(state.func_177229_b((IProperty)activeProperty));
            }
            if (builder.length() == 0) {
                builder.append("normal");
            }
            ResourceLocation baseLocation = new ResourceLocation("bfr", nameOverride != null ? nameOverride : type.func_176610_l());
            return new ModelResourceLocation(baseLocation, builder.toString());
        }
    }

    public static class ReactorBlockPredicate
    implements Predicate<ReactorBlockType> {
        public ReactorBlock basicBlock;

        public ReactorBlockPredicate(ReactorBlock type) {
            this.basicBlock = type;
        }

        public boolean apply(ReactorBlockType input) {
            return input.blockType == this.basicBlock;
        }
    }

    public static enum ReactorBlockType implements IStringSerializable
    {
        REACTOR_CONTROLLER(ReactorBlock.REACTOR_BLOCK, 0, "ReactorController", 10, TileEntityReactorController::new, true),
        REACTOR_FRAME(ReactorBlock.REACTOR_BLOCK, 1, "ReactorFrame", -1, TileEntityReactorFrame::new, false),
        REACTOR_PORT(ReactorBlock.REACTOR_BLOCK, 2, "ReactorPort", -1, TileEntityReactorPort::new, true),
        REACTOR_LOGIC_ADAPTER(ReactorBlock.REACTOR_BLOCK, 3, "ReactorLogicAdapter", 15, TileEntityReactorLogicAdapter::new, false),
        REACTOR_GLASS(ReactorBlock.REACTOR_GLASS, 0, "ReactorGlass", -1, TileEntityReactorGlass::new, false),
        LASER_FOCUS_MATRIX(ReactorBlock.REACTOR_GLASS, 1, "ReactorLaserFocusMatrix", -1, TileEntityReactorLaserFocusMatrix::new, false);

        public ReactorBlock blockType;
        public int meta;
        public String name;
        public int guiId;
        public Supplier<TileEntityElectricBlock> tileEntitySupplier;
        public boolean activable;

        private ReactorBlockType(ReactorBlock b, int i, String s, int j, Supplier<TileEntityElectricBlock> tileClass, boolean activeState) {
            this.blockType = b;
            this.meta = i;
            this.name = s;
            this.guiId = j;
            this.tileEntitySupplier = tileClass;
            this.activable = activeState;
        }

        public static ReactorBlockType get(Block block, int meta) {
            if (block instanceof BlockReactor) {
                return ReactorBlockType.get(((BlockReactor)block).getReactorBlock(), meta);
            }
            return null;
        }

        public static ReactorBlockType get(ReactorBlock block, int meta) {
            for (ReactorBlockType type : ReactorBlockType.values()) {
                if (type.meta != meta || type.blockType != block) continue;
                return type;
            }
            return null;
        }

        public static ReactorBlockType get(ItemStack stack) {
            return ReactorBlockType.get(Block.func_149634_a((Item)stack.func_77973_b()), stack.func_77952_i());
        }

        public TileEntity create() {
            return this.tileEntitySupplier != null ? (TileEntity)this.tileEntitySupplier.get() : null;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String getDescription() {
            return LangUtils.localize((String)("tooltip." + this.name));
        }

        public ItemStack getStack(int amount) {
            return new ItemStack(this.blockType.getBlock(), amount, this.meta);
        }

        public boolean hasActiveTexture() {
            return this.activable;
        }
    }

    public static enum ReactorBlock {
        REACTOR_BLOCK,
        REACTOR_GLASS;

        private PropertyEnum<ReactorBlockType> predicatedProperty;

        public PropertyEnum<ReactorBlockType> getProperty() {
            if (this.predicatedProperty == null) {
                this.predicatedProperty = PropertyEnum.func_177708_a((String)"type", ReactorBlockType.class, (Predicate)new ReactorBlockPredicate(this));
            }
            return this.predicatedProperty;
        }

        public Block getBlock() {
            switch (this) {
                case REACTOR_BLOCK: {
                    return BFRBlocks.Reactor;
                }
                case REACTOR_GLASS: {
                    return BFRBlocks.ReactorGlass;
                }
            }
            return null;
        }
    }
}

