/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.common.block.states;

import igentuman.bfr.common.BFRBlocks;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.common.base.IBlockType;
import mekanism.common.block.states.BlockStateFacing;
import mekanism.common.block.states.BlockStateUtils;
import mekanism.common.util.LangUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockStateGenerator
extends ExtendedBlockState {
    public static final PropertyBool activeProperty = PropertyBool.func_177716_a((String)"active");

    public BlockStateGenerator(Block block, PropertyEnum<?> typeProperty) {
        super(block, new IProperty[]{BlockStateFacing.facingProperty, typeProperty, activeProperty}, new IUnlistedProperty[0]);
    }

    public static enum GeneratorType implements IStringSerializable,
    IBlockType
    {

        private static final List<GeneratorType> GENERATORS_FOR_CONFIG = new ArrayList<GeneratorType>();
        public GeneratorBlock blockType;
        public int meta;
        public String blockName;
        public int guiId;
        public double maxEnergy;
        public Supplier<TileEntity> tileEntitySupplier;
        public boolean hasModel;
        public Predicate<EnumFacing> facingPredicate;
        public boolean activable;
        public boolean hasRedstoneOutput;

        private GeneratorType(GeneratorBlock block, int m, String name, int gui, double energy, Supplier<TileEntity> tileClass, boolean model, Predicate<EnumFacing> predicate, boolean hasActiveTexture) {
            this(block, m, name, gui, energy, tileClass, model, predicate, hasActiveTexture, false);
        }

        private GeneratorType(GeneratorBlock block, int m, String name, int gui, double energy, Supplier<TileEntity> tileClass, boolean model, Predicate<EnumFacing> predicate, boolean hasActiveTexture, boolean hasRedstoneOutput) {
            this.blockType = block;
            this.meta = m;
            this.blockName = name;
            this.guiId = gui;
            this.maxEnergy = energy;
            this.tileEntitySupplier = tileClass;
            this.hasModel = model;
            this.facingPredicate = predicate;
            this.activable = hasActiveTexture;
            this.hasRedstoneOutput = hasRedstoneOutput;
        }

        public static List<GeneratorType> getGeneratorsForConfig() {
            return GENERATORS_FOR_CONFIG;
        }

        public static GeneratorType get(IBlockState state) {
            return null;
        }

        public static GeneratorType get(Block block, int meta) {
            return null;
        }

        public static GeneratorType get(GeneratorBlock block, int meta) {
            for (GeneratorType type : GeneratorType.values()) {
                if (type.meta != meta || type.blockType != block) continue;
                return type;
            }
            return null;
        }

        public static GeneratorType get(ItemStack stack) {
            return GeneratorType.get(Block.func_149634_a((Item)stack.func_77973_b()), stack.func_77952_i());
        }

        public String getBlockName() {
            return this.blockName;
        }

        public boolean isEnabled() {
            return true;
        }

        public TileEntity create() {
            return this.tileEntitySupplier != null ? this.tileEntitySupplier.get() : null;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String getDescription() {
            return LangUtils.localize((String)("tooltip." + this.blockName));
        }

        public ItemStack getStack() {
            return new ItemStack(BFRBlocks.Reactor, 1, this.meta);
        }

        public boolean canRotateTo(EnumFacing side) {
            return this.facingPredicate.test(side);
        }

        public boolean hasRotations() {
            return !this.facingPredicate.equals(BlockStateUtils.NO_ROTATION);
        }

        public boolean hasActiveTexture() {
            return this.activable;
        }

        static {
            for (GeneratorType type : GeneratorType.values()) {
                if (type.ordinal() > 5) continue;
                GENERATORS_FOR_CONFIG.add(type);
            }
        }
    }

    public static enum GeneratorBlock {
        GENERATOR_BLOCK_1;

        PropertyEnum<GeneratorType> generatorTypeProperty;

        public PropertyEnum<GeneratorType> getProperty() {
            if (this.generatorTypeProperty == null) {
                this.generatorTypeProperty = PropertyEnum.func_177708_a((String)"type", GeneratorType.class, input -> input != null && input.blockType == this);
            }
            return this.generatorTypeProperty;
        }

        public Block getBlock() {
            return null;
        }
    }
}

