/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.common;

import igentuman.bfr.common.config.BfrConfig;
import igentuman.bfr.common.recipes.BFRRecipes;
import igentuman.bfr.common.recipes.ReactorCoolantRecipe;
import igentuman.bfr.common.tile.reactor.TileEntityReactorBlock;
import igentuman.bfr.common.tile.reactor.TileEntityReactorController;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.IHeatTransfer;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.common.LaserManager;
import mekanism.common.Mekanism;
import mekanism.common.MekanismFluids;
import mekanism.common.config.MekanismConfig;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.generators.common.item.ItemHohlraum;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BetterFusionReactor {
    public static final int MAX_INJECTION = 98;
    public static double burnTemperature = UnitDisplayUtils.TemperatureUnit.AMBIENT.convertFromK(1.0E8, true);
    public static double burnRatio = 1.0;
    public static double plasmaHeatCapacity = 100.0;
    public static double caseHeatCapacity = 1.0;
    public static double enthalpyOfVaporization = 10.0;
    public static double thermocoupleEfficiency = 0.05;
    public static double steamTransferEfficiency = 0.1;
    public static double plasmaCaseConductivity = 0.2;
    public static double caseWaterConductivity = 0.3;
    public static double caseAirConductivity = 0.1;
    public TileEntityReactorController controller;
    public Set<TileEntityReactorBlock> reactorBlocks = new HashSet<TileEntityReactorBlock>();
    public Set<IHeatTransfer> heatTransfers = new HashSet<IHeatTransfer>();
    public double plasmaTemperature;
    public double caseTemperature;
    public double lastPlasmaTemperature;
    public double lastCaseTemperature;
    public float currentReactivity = 0.0f;
    public float targetReactivity = 0.0f;
    public float errorLevel = 0.0f;
    public float adjustment = 0.0f;
    public double heatToAbsorb = 0.0;
    public int injectionRate = 0;
    public boolean burning = false;
    public boolean activelyCooled = true;
    public int reactivityUpdateTicks = 10000;
    public int currentReactivityTick = 0;
    public boolean updatedThisTick;
    public int adjustmentTicks = 100;
    public boolean formed = false;
    public int laserShootCountdown = 0;
    public int laserShootEnergyDuration = 12000;
    public double laserShootMinEnergy = 5.0E8;
    public int difficulty = Math.min(20, Math.max(BfrConfig.reactionDifficulty, 1));
    private Fluid cachedOutput;
    private Fluid cachedInput;
    private ReactorCoolantRecipe currentRecipe;
    private double coolantConversionRate = 1.0;

    public BetterFusionReactor(TileEntityReactorController c) {
        this.controller = c;
    }

    public void addTemperatureFromEnergyInput(double energyAdded) {
        this.plasmaTemperature += energyAdded / plasmaHeatCapacity * (double)(this.isBurning() ? 1 : 10);
        this.processLaserShoot(energyAdded);
    }

    public float getTargetReactivity() {
        return this.targetReactivity;
    }

    public float getEfficiency() {
        if (!this.isBurning()) {
            return 0.0f;
        }
        return (float)Math.min(100.0, Math.max(0.0, 1.0 / ((double)(Math.abs(this.targetReactivity - this.currentReactivity) / 100.0f) + 0.2) * 22.0) - 10.0);
    }

    public void setAdjustment(float val) {
        this.adjustment = val;
    }

    public float getAdjustment() {
        return this.adjustment;
    }

    public float getCurrentReactivity() {
        return this.currentReactivity;
    }

    public void setTargetReactivity(float val) {
        this.targetReactivity = Math.abs(val);
    }

    public void setCurrentReactivity(float val) {
        this.currentReactivity = Math.abs(val);
    }

    public float getErrorLevel() {
        return this.errorLevel;
    }

    public void setErrorLevel(float val) {
        this.errorLevel = val;
    }

    public int getLaserShootCountdown() {
        return this.laserShootCountdown;
    }

    public void setLaserShootCountdown(int val) {
        this.laserShootCountdown = val;
    }

    public void processLaserShoot(double laserEnergy) {
        if (laserEnergy >= this.laserShootMinEnergy && this.laserShootCountdown == 0) {
            this.laserShootCountdown = this.laserShootEnergyDuration;
        }
    }

    public void laserShootCount() {
        if (this.laserShootCountdown > 0) {
            --this.laserShootCountdown;
        }
    }

    public float getKt() {
        if (this.laserShootEnergyDuration - this.getLaserShootCountdown() < 1200) {
            return 0.0f;
        }
        float tDevide = 20.0f;
        if (this.activelyCooled) {
            tDevide = 30.0f;
        }
        return (float)Math.pow((float)Math.abs(Math.sqrt((float)this.getPlasmaTemp() / 1000000.0f) - 40.0) / tDevide, 2.0);
    }

    public void updateErrorLevel() {
        if (this.isBurning()) {
            float shift = (80.0f - this.getEfficiency()) * ((this.getKt() + 1.0f) / 2.0f) * 5.0E-4f;
            if (shift > 0.0f) {
                shift = shift * (float)this.difficulty / 10.0f;
            }
            this.errorLevel += shift;
        } else {
            this.errorLevel = (float)((double)this.errorLevel - 0.1);
        }
        this.errorLevel = Math.min(100.0f, Math.max(0.0f, this.errorLevel));
        if (this.errorLevel >= 100.0f) {
            this.currentReactivity = 0.0f;
            this.targetReactivity = 0.0f;
            this.adjustment = 0.0f;
            this.burning = false;
            if (BfrConfig.reactorMeltdown) {
                this.controller.func_145831_w().func_72876_a(null, (double)this.controller.func_174877_v().func_177958_n(), (double)(this.controller.func_174877_v().func_177956_o() + 1), (double)this.controller.func_174877_v().func_177952_p(), BfrConfig.explosionRadius, true);
            }
        }
    }

    public boolean adjustReactivity(float rate) {
        if (this.adjustment != 0.0f) {
            return false;
        }
        this.adjustment = rate / (float)this.adjustmentTicks;
        return true;
    }

    public void updateAdjustment() {
        if (this.adjustment == 0.0f) {
            return;
        }
        this.currentReactivity += this.adjustment;
        this.currentReactivity = Math.min(100.0f, Math.max(0.0f, this.currentReactivity));
        --this.adjustmentTicks;
        if (this.adjustmentTicks < 1) {
            this.adjustmentTicks = 100;
            this.adjustment = 0.0f;
        }
    }

    public boolean hasHohlraum() {
        ItemStack hohlraum;
        if (this.controller != null && !(hohlraum = (ItemStack)this.controller.inventory.get(0)).func_190926_b() && hohlraum.func_77973_b() instanceof ItemHohlraum) {
            GasStack gasStack = ((ItemHohlraum)hohlraum.func_77973_b()).getGas(hohlraum);
            return gasStack != null && gasStack.getGas() == MekanismFluids.FusionFuel && gasStack.amount == 10;
        }
        return false;
    }

    public int reactivityUpdateTicksScaled() {
        return (int)((double)this.reactivityUpdateTicks / ((double)this.getKt() + 0.25) * (double)((float)this.difficulty / 10.0f));
    }

    public void updateReactivity() {
        float low = 0.0f;
        float high = 100.0f;
        ++this.currentReactivityTick;
        if (this.reactivityUpdateTicksScaled() < this.currentReactivityTick) {
            this.currentReactivityTick = 0;
            this.setTargetReactivity(low + new Random().nextFloat() * (high - low));
        }
    }

    public void simulate() {
        if (this.controller.func_145831_w().field_72995_K) {
            this.lastPlasmaTemperature = this.plasmaTemperature;
            this.lastCaseTemperature = this.caseTemperature;
            return;
        }
        this.updatedThisTick = false;
        if (this.plasmaTemperature >= burnTemperature) {
            if (!this.burning && this.hasHohlraum()) {
                this.vaporiseHohlraum();
                float low = 0.0f;
                float high = 100.0f;
                this.setCurrentReactivity(low + new Random().nextFloat() * (high - low));
                this.setTargetReactivity(low + new Random().nextFloat() * (high - low));
            }
            this.updateErrorLevel();
            if (this.burning) {
                this.laserShootCount();
                this.activelyCooled = this.getWaterTank().getFluidAmount() > 0;
                this.updateReactivity();
                this.updateAdjustment();
                this.injectFuel();
                int fuelBurned = this.burnFuel();
                if (fuelBurned == 0) {
                    this.burning = false;
                }
            }
        } else {
            this.currentReactivity = 0.0f;
            this.targetReactivity = 0.0f;
            this.adjustment = 0.0f;
            this.burning = false;
        }
        this.transferHeat();
        if (this.burning) {
            this.kill();
        }
        this.updateTemperatures();
    }

    public void updateTemperatures() {
        this.lastPlasmaTemperature = this.plasmaTemperature < 0.1 ? 0.0 : this.plasmaTemperature;
        this.lastCaseTemperature = this.caseTemperature < 0.1 ? 0.0 : this.caseTemperature;
    }

    public void vaporiseHohlraum() {
        this.getFuelTank().receive(((ItemHohlraum)((ItemStack)this.controller.inventory.get(0)).func_77973_b()).getGas((ItemStack)this.controller.inventory.get(0)), true);
        this.lastPlasmaTemperature = this.plasmaTemperature;
        this.controller.inventory.set(0, (Object)ItemStack.field_190927_a);
        this.burning = true;
    }

    public void injectFuel() {
        int amountNeeded = this.getFuelTank().getNeeded();
        int amountAvailable = 2 * Math.min(this.getDeuteriumTank().getStored(), this.getTritiumTank().getStored());
        int amountToInject = Math.min(amountNeeded, Math.min(amountAvailable, this.injectionRate));
        amountToInject -= amountToInject % 2;
        this.getDeuteriumTank().draw(amountToInject / 2, true);
        this.getTritiumTank().draw(amountToInject / 2, true);
        this.getFuelTank().receive(new GasStack(MekanismFluids.FusionFuel, amountToInject), true);
    }

    public int burnFuel() {
        int fuelBurned = (int)Math.max((double)this.injectionRate, Math.min((double)this.getFuelTank().getStored(), Math.max(0.0, this.lastPlasmaTemperature - burnTemperature) * burnRatio));
        this.getFuelTank().draw(fuelBurned, true);
        this.plasmaTemperature += MekanismConfig.current().generators.energyPerFusionFuel.val() * (double)fuelBurned / plasmaHeatCapacity;
        return fuelBurned;
    }

    public Fluid getFluidOutput() {
        block4: {
            block3: {
                if (this.getWaterTank().getFluid() == null) {
                    return null;
                }
                if (this.cachedInput == null || !this.cachedInput.equals(this.getWaterTank().getFluid().getFluid())) break block3;
                if (this.cachedOutput != null) break block4;
                for (ReactorCoolantRecipe recipe : BFRRecipes.REACTOR_COOLANT.getAll()) {
                    if (!this.cachedInput.equals(recipe.getInput().getFluidStacks().get(0).getFluid())) continue;
                    this.cachedOutput = recipe.getOutput().getFluid();
                    this.currentRecipe = recipe;
                    caseWaterConductivity = (double)recipe.getOutput().amount / 10000.0;
                    this.coolantConversionRate = (double)recipe.getOutput().amount / (double)recipe.getInput().getFluidStacks().get((int)0).amount;
                }
                break block4;
            }
            this.cachedInput = this.getWaterTank().getFluid().getFluid();
            for (ReactorCoolantRecipe recipe : BFRRecipes.REACTOR_COOLANT.getAll()) {
                if (!this.cachedInput.equals(recipe.getInput().getFluidStacks().get(0).getFluid())) continue;
                this.cachedOutput = recipe.getOutput().getFluid();
                this.currentRecipe = recipe;
                caseWaterConductivity = (double)recipe.getOutput().amount / 10000.0;
                this.coolantConversionRate = (double)recipe.getOutput().amount / (double)recipe.getInput().getFluidStacks().get((int)0).amount;
            }
        }
        return this.cachedOutput;
    }

    public void transferHeat() {
        double plasmaCaseHeat = plasmaCaseConductivity * (this.lastPlasmaTemperature - this.lastCaseTemperature);
        this.plasmaTemperature -= plasmaCaseHeat / plasmaHeatCapacity;
        this.caseTemperature += plasmaCaseHeat / caseHeatCapacity;
        if (this.activelyCooled) {
            double caseWaterHeat = caseWaterConductivity * this.lastCaseTemperature;
            int waterToVaporize = (int)(steamTransferEfficiency * caseWaterHeat / enthalpyOfVaporization);
            if ((waterToVaporize = Math.min(waterToVaporize, Math.min(this.getWaterTank().getFluidAmount(), this.getSteamTank().getCapacity() - this.getSteamTank().getFluidAmount()))) > 0 && this.getFluidOutput() != null) {
                this.getSteamTank().fill(new FluidStack(this.getFluidOutput(), waterToVaporize), true);
                this.getWaterTank().drain((int)((double)waterToVaporize / this.coolantConversionRate), true);
            }
            caseWaterHeat = (double)waterToVaporize * enthalpyOfVaporization / steamTransferEfficiency;
            this.caseTemperature -= caseWaterHeat / caseHeatCapacity;
            for (IHeatTransfer source : this.heatTransfers) {
                source.simulateHeat();
            }
            this.applyTemperatureChange();
        }
        double caseAirHeat = caseAirConductivity * this.lastCaseTemperature;
        this.caseTemperature -= caseAirHeat / caseHeatCapacity;
        this.setBufferedEnergy(this.getBufferedEnergy() + caseAirHeat * thermocoupleEfficiency);
    }

    public FluidTank getWaterTank() {
        return this.controller != null ? this.controller.waterTank : null;
    }

    public FluidTank getSteamTank() {
        return this.controller.steamTank;
    }

    public GasTank getDeuteriumTank() {
        return this.controller.deuteriumTank;
    }

    public GasTank getTritiumTank() {
        return this.controller.tritiumTank;
    }

    public GasTank getFuelTank() {
        return this.controller.fuelTank;
    }

    public double getBufferedEnergy() {
        return this.controller.getEnergy();
    }

    public void setBufferedEnergy(double energy) {
        this.controller.setEnergy(energy);
    }

    public double getPlasmaTemp() {
        return this.lastPlasmaTemperature;
    }

    public void setPlasmaTemp(double temp) {
        this.plasmaTemperature = temp;
    }

    public double getCaseTemp() {
        return this.lastCaseTemperature;
    }

    public void setCaseTemp(double temp) {
        this.caseTemperature = temp;
    }

    public double getBufferSize() {
        return this.controller.getMaxEnergy();
    }

    public void kill() {
        AxisAlignedBB death_zone = new AxisAlignedBB((double)(this.controller.func_174877_v().func_177958_n() - 1), (double)(this.controller.func_174877_v().func_177956_o() - 3), (double)(this.controller.func_174877_v().func_177952_p() - 1), (double)(this.controller.func_174877_v().func_177958_n() + 2), (double)this.controller.func_174877_v().func_177956_o(), (double)(this.controller.func_174877_v().func_177952_p() + 2));
        List entitiesToDie = this.controller.func_145831_w().func_72872_a(Entity.class, death_zone);
        for (Entity entity : entitiesToDie) {
            entity.func_70097_a(DamageSource.field_76376_m, 50000.0f);
        }
    }

    public void unformMultiblock(boolean keepBurning) {
        for (TileEntityReactorBlock block : this.reactorBlocks) {
            block.setReactor(null);
        }
        this.controller.setReactor(this);
        this.reactorBlocks.clear();
        this.formed = false;
        boolean bl = this.burning = this.burning && keepBurning;
        if (!this.controller.func_145831_w().field_72995_K) {
            Mekanism.packetHandler.sendToDimension((IMessage)new PacketTileEntity.TileEntityMessage((TileEntity)this.controller), this.controller.func_145831_w().field_73011_w.getDimension());
        }
    }

    public void formMultiblock(boolean keepBurning) {
        this.updatedThisTick = true;
        Coord4D controllerPosition = Coord4D.get((TileEntity)this.controller);
        Coord4D centreOfReactor = controllerPosition.offset(EnumFacing.DOWN, 2);
        this.unformMultiblock(true);
        this.reactorBlocks.add(this.controller);
        if (!(this.createFrame(centreOfReactor) && this.addSides(centreOfReactor) && this.centreIsClear(centreOfReactor))) {
            this.unformMultiblock(keepBurning);
            return;
        }
        this.formed = true;
        if (!this.controller.func_145831_w().field_72995_K) {
            Mekanism.packetHandler.sendToDimension((IMessage)new PacketTileEntity.TileEntityMessage((TileEntity)this.controller), this.controller.func_145831_w().field_73011_w.getDimension());
        }
    }

    public boolean createFrame(Coord4D centre) {
        int[][] positions;
        for (int[] coords : positions = new int[][]{{2, 2, 0}, {2, 1, 1}, {2, 0, 2}, {2, -1, 1}, {2, -2, 0}, {2, -1, -1}, {2, 0, -2}, {2, 1, -1}, {1, 2, 1}, {1, 1, 2}, {1, -1, 2}, {1, -2, 1}, {1, -2, -1}, {1, -1, -2}, {1, 1, -2}, {1, 2, -1}, {0, 2, 2}, {0, -2, 2}, {0, -2, -2}, {0, 2, -2}, {-1, 2, 1}, {-1, 1, 2}, {-1, -1, 2}, {-1, -2, 1}, {-1, -2, -1}, {-1, -1, -2}, {-1, 1, -2}, {-1, 2, -1}, {-2, 2, 0}, {-2, 1, 1}, {-2, 0, 2}, {-2, -1, 1}, {-2, -2, 0}, {-2, -1, -1}, {-2, 0, -2}, {-2, 1, -1}}) {
            TileEntity tile = centre.clone().translate(coords[0], coords[1], coords[2]).getTileEntity((IBlockAccess)this.controller.func_145831_w());
            if (!(tile instanceof TileEntityReactorBlock) || !((TileEntityReactorBlock)tile).isFrame()) {
                return false;
            }
            this.reactorBlocks.add((TileEntityReactorBlock)tile);
            ((TileEntityReactorBlock)tile).setReactor(this);
        }
        return true;
    }

    public boolean addSides(Coord4D centre) {
        int[][] positions;
        for (int[] coords : positions = new int[][]{{2, 0, 0}, {2, 1, 0}, {2, 0, 1}, {2, -1, 0}, {2, 0, -1}, {-2, 0, 0}, {-2, 1, 0}, {-2, 0, 1}, {-2, -1, 0}, {-2, 0, -1}, {0, 2, 0}, {1, 2, 0}, {0, 2, 1}, {-1, 2, 0}, {0, 2, -1}, {0, -2, 0}, {1, -2, 0}, {0, -2, 1}, {-1, -2, 0}, {0, -2, -1}, {0, 0, 2}, {1, 0, 2}, {0, 1, 2}, {-1, 0, 2}, {0, -1, 2}, {0, 0, -2}, {1, 0, -2}, {0, 1, -2}, {-1, 0, -2}, {0, -1, -2}}) {
            TileEntity tile = centre.clone().translate(coords[0], coords[1], coords[2]).getTileEntity((IBlockAccess)this.controller.func_145831_w());
            if (LaserManager.isReceptor((TileEntity)tile, null) && (coords[1] != 0 || coords[0] != 0 && coords[2] != 0)) {
                return false;
            }
            if (tile instanceof TileEntityReactorBlock) {
                this.reactorBlocks.add((TileEntityReactorBlock)tile);
                ((TileEntityReactorBlock)tile).setReactor(this);
                if (!(tile instanceof IHeatTransfer)) continue;
                this.heatTransfers.add((IHeatTransfer)tile);
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean centreIsClear(Coord4D centre) {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    Coord4D trans = centre.translate(x, y, z);
                    IBlockState state = trans.getBlockState((IBlockAccess)this.controller.func_145831_w());
                    Block tile = state.func_177230_c();
                    if (tile.isAir(state, (IBlockAccess)this.controller.func_145831_w(), trans.getPos())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isFormed() {
        return this.formed;
    }

    public int getInjectionRate() {
        return this.injectionRate;
    }

    public void setInjectionRate(int rate) {
        this.injectionRate = rate;
        int capRate = Math.min(Math.max(1, rate), 98);
        capRate -= capRate % 2;
        this.controller.waterTank.setCapacity(100000 * capRate);
        this.controller.steamTank.setCapacity(10000000 * capRate);
        if (this.controller.waterTank.getFluid() != null) {
            this.controller.waterTank.getFluid().amount = Math.min(this.controller.waterTank.getFluid().amount, this.controller.waterTank.getCapacity());
        }
        if (this.controller.steamTank.getFluid() != null) {
            this.controller.steamTank.getFluid().amount = Math.min(this.controller.steamTank.getFluid().amount, this.controller.steamTank.getCapacity());
        }
    }

    public boolean isBurning() {
        return this.burning;
    }

    public void setBurning(boolean burn) {
        this.burning = burn;
    }

    public int getMinInjectionRate(boolean active) {
        double k = active ? caseWaterConductivity : 0.0;
        double aMin = burnTemperature * burnRatio * plasmaCaseConductivity * (k + caseAirConductivity) / (MekanismConfig.current().generators.energyPerFusionFuel.val() * burnRatio * (plasmaCaseConductivity + k + caseAirConductivity) - plasmaCaseConductivity * (k + caseAirConductivity));
        return (int)(2.0 * Math.ceil(aMin / 2.0));
    }

    public double getMaxPlasmaTemperature(boolean active) {
        double k = active ? caseWaterConductivity : 0.0;
        return (double)this.injectionRate * MekanismConfig.current().generators.energyPerFusionFuel.val() / plasmaCaseConductivity * (plasmaCaseConductivity + k + caseAirConductivity) / (k + caseAirConductivity);
    }

    public double getMaxCasingTemperature(boolean active) {
        double k = active ? caseWaterConductivity : 0.0;
        return (double)this.injectionRate * MekanismConfig.current().generators.energyPerFusionFuel.val() / (k + caseAirConductivity);
    }

    public double getIgnitionTemperature(boolean active) {
        double k = active ? caseWaterConductivity : 0.0;
        return burnTemperature * MekanismConfig.current().generators.energyPerFusionFuel.val() * burnRatio * (plasmaCaseConductivity + k + caseAirConductivity) / (MekanismConfig.current().generators.energyPerFusionFuel.val() * burnRatio * (plasmaCaseConductivity + k + caseAirConductivity) - plasmaCaseConductivity * (k + caseAirConductivity));
    }

    public double getPassiveGeneration(boolean active, boolean current) {
        double temperature = current ? this.caseTemperature : this.getMaxCasingTemperature(active);
        return thermocoupleEfficiency * caseAirConductivity * temperature * (double)((this.getEfficiency() / 100.0f + 2.0f) / 3.0f);
    }

    public int getSteamPerTick(boolean current) {
        double temperature = current ? this.caseTemperature : this.getMaxCasingTemperature(true);
        return (int)(steamTransferEfficiency * caseWaterConductivity * temperature / enthalpyOfVaporization * (double)((this.getEfficiency() / 100.0f + 2.0f) / 3.0f));
    }

    public double getTemp() {
        return this.lastCaseTemperature;
    }

    public double getInverseConductionCoefficient() {
        return 1.0 / caseAirConductivity;
    }

    public double getInsulationCoefficient(EnumFacing side) {
        return 100000.0;
    }

    public void transferHeatTo(double heat) {
        this.heatToAbsorb += heat;
    }

    public double[] simulateHeat() {
        return null;
    }

    public double applyTemperatureChange() {
        this.caseTemperature += this.heatToAbsorb / caseHeatCapacity;
        this.heatToAbsorb = 0.0;
        return this.caseTemperature;
    }

    public boolean canConnectHeat(EnumFacing side) {
        return false;
    }

    public IHeatTransfer getAdjacent(EnumFacing side) {
        return null;
    }

    public NonNullList<ItemStack> getInventory() {
        return this.isFormed() ? this.controller.inventory : null;
    }
}

