/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.client.gui.element;

import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiEfficiencyBar
extends GuiElement {
    private final IStrictEnergyStorage tileEntity;
    private final IPowerInfoHandler handler;
    private final int xLocation;
    private final int yLocation;
    private final int width = 6;
    private final int height = 56;

    public GuiEfficiencyBar(IGuiWrapper gui, IStrictEnergyStorage tile, ResourceLocation def, int x, int y) {
        super(new ResourceLocation("bfr", MekanismUtils.ResourceType.GUI_ELEMENT.getPrefix() + "GuiEfficiencyBar.png"), gui, def);
        this.tileEntity = tile;
        this.handler = new IPowerInfoHandler(){

            @Override
            public String getTooltip() {
                return MekanismUtils.getEnergyDisplay((double)GuiEfficiencyBar.this.tileEntity.getEnergy(), (double)GuiEfficiencyBar.this.tileEntity.getMaxEnergy());
            }

            @Override
            public double getLevel() {
                return GuiEfficiencyBar.this.tileEntity.getEnergy() / GuiEfficiencyBar.this.tileEntity.getMaxEnergy();
            }
        };
        this.xLocation = x;
        this.yLocation = y;
    }

    public GuiEfficiencyBar(IGuiWrapper gui, IPowerInfoHandler h, ResourceLocation def, int x, int y) {
        super(new ResourceLocation("bfr", MekanismUtils.ResourceType.GUI_ELEMENT.getPrefix() + "GuiEfficiencyBar.png"), gui, def);
        this.tileEntity = null;
        this.handler = h;
        this.xLocation = x;
        this.yLocation = y;
    }

    public GuiElement.Rectangle4i getBounds(int guiWidth, int guiHeight) {
        return new GuiElement.Rectangle4i(guiWidth + this.xLocation, guiHeight + this.yLocation, 6, 56);
    }

    protected boolean inBounds(int xAxis, int yAxis) {
        return xAxis >= this.xLocation && xAxis <= this.xLocation + 6 && yAxis >= this.yLocation && yAxis <= this.yLocation + 56;
    }

    public void renderBackground(int xAxis, int yAxis, int guiWidth, int guiHeight) {
        GuiEfficiencyBar.mc.field_71446_o.func_110577_a(this.RESOURCE);
        this.guiObj.drawTexturedRect(guiWidth + this.xLocation, guiHeight + this.yLocation, 0, 0, 6, 56);
        if (this.handler.getLevel() > 0.0) {
            int displayInt = (int)(this.handler.getLevel() * 52.0) + 2;
            this.guiObj.drawTexturedRect(guiWidth + this.xLocation, guiHeight + this.yLocation + 56 - displayInt, 6, 56 - displayInt, 6, displayInt);
        }
        GuiEfficiencyBar.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    public void renderForeground(int xAxis, int yAxis) {
        GuiEfficiencyBar.mc.field_71446_o.func_110577_a(this.RESOURCE);
        if (this.handler.getTooltip() != null && this.inBounds(xAxis, yAxis)) {
            this.displayTooltip(this.handler.getTooltip(), xAxis, yAxis);
        }
        GuiEfficiencyBar.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    public void preMouseClicked(int xAxis, int yAxis, int button) {
    }

    public void mouseClicked(int xAxis, int yAxis, int button) {
    }

    public static abstract class IPowerInfoHandler {
        public String getTooltip() {
            return null;
        }

        public abstract double getLevel();
    }
}

