/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.client.gui;

import igentuman.bfr.client.gui.GuiReactorInfo;
import igentuman.bfr.client.gui.element.GuiEfficiencyBar;
import igentuman.bfr.client.gui.element.GuiHeatBar;
import igentuman.bfr.client.gui.element.GuiReactorTab;
import igentuman.bfr.common.tile.reactor.TileEntityReactorController;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import mekanism.api.EnumColor;
import mekanism.api.TileNetworkList;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiReactorEfficiency
extends GuiReactorInfo {
    private GuiButton plusButton;
    private GuiButton minusButton;
    private GuiButton helpButton;
    private GuiButton laserReadyButton;
    private ArrayList<String> help = new ArrayList();
    private ArrayList<String> laser = new ArrayList();

    public GuiReactorEfficiency(InventoryPlayer inventory, TileEntityReactorController tile) {
        super(tile, (Container)new ContainerNull(inventory.field_70458_d, (TileEntityContainerBlock)tile));
        ResourceLocation resource = this.getGuiLocation();
        this.help.add(LangUtils.localize((String)"gui.reactor.efficiency_help1"));
        this.help.add(LangUtils.localize((String)"gui.reactor.efficiency_help2"));
        this.help.add(LangUtils.localize((String)"gui.reactor.efficiency_help3"));
        this.laser.add(LangUtils.localize((String)"gui.reactor.laserMinEnergy") + ": " + MekanismUtils.getEnergyDisplay((double)((TileEntityReactorController)this.tileEntity).getReactor().laserShootMinEnergy));
        this.laser.add(LangUtils.localize((String)"gui.reactor.laserMinEnergy.desc"));
        this.addGuiElement((GuiElement)new GuiPowerBar((IGuiWrapper)this, new GuiPowerBar.IPowerInfoHandler(){

            public String getTooltip() {
                return LangUtils.localize((String)"gui.reactor.current_reactivity") + ": " + String.format("%.1f", Float.valueOf(((TileEntityReactorController)GuiReactorEfficiency.this.tileEntity).getReactor().getCurrentReactivity()));
            }

            public double getLevel() {
                return ((TileEntityReactorController)GuiReactorEfficiency.this.tileEntity).getReactor().getCurrentReactivity() / 100.0f;
            }
        }, resource, 30, 55));
        this.addGuiElement((GuiElement)new GuiPowerBar((IGuiWrapper)this, new GuiPowerBar.IPowerInfoHandler(){

            public String getTooltip() {
                return LangUtils.localize((String)"gui.reactor.target_reactivity") + ": " + String.format("%.1f", Float.valueOf(((TileEntityReactorController)GuiReactorEfficiency.this.tileEntity).getReactor().getTargetReactivity()));
            }

            public double getLevel() {
                return ((TileEntityReactorController)GuiReactorEfficiency.this.tileEntity).getReactor().getTargetReactivity() / 100.0f;
            }
        }, resource, 64, 55));
        this.addGuiElement(new GuiEfficiencyBar((IGuiWrapper)this, new GuiEfficiencyBar.IPowerInfoHandler(){

            @Override
            public String getTooltip() {
                return LangUtils.localize((String)"gui.reactor.efficiency") + ": " + String.format("%.2f", Float.valueOf(((TileEntityReactorController)GuiReactorEfficiency.this.tileEntity).getReactor().getEfficiency())) + "%";
            }

            @Override
            public double getLevel() {
                return ((TileEntityReactorController)GuiReactorEfficiency.this.tileEntity).getReactor().getEfficiency() / 100.0f;
            }
        }, resource, 102, 55));
        this.addGuiElement(new GuiHeatBar((IGuiWrapper)this, new GuiHeatBar.IPowerInfoHandler(){

            @Override
            public String getTooltip() {
                return LangUtils.localize((String)"gui.reactor.error_level") + ": " + String.format("%.2f", Float.valueOf(((TileEntityReactorController)GuiReactorEfficiency.this.tileEntity).getReactor().getErrorLevel())) + "%";
            }

            @Override
            public double getLevel() {
                return ((TileEntityReactorController)GuiReactorEfficiency.this.tileEntity).getReactor().getErrorLevel() / 100.0f;
            }
        }, resource, 142, 55));
        this.addGuiElement((GuiElement)new GuiEnergyInfo(() -> ((TileEntityReactorController)this.tileEntity).isFormed() ? Arrays.asList(LangUtils.localize((String)"gui.storing") + ": " + MekanismUtils.getEnergyDisplay((double)((TileEntityReactorController)this.tileEntity).getEnergy(), (double)((TileEntityReactorController)this.tileEntity).getMaxEnergy()), LangUtils.localize((String)"gui.producing") + ": " + MekanismUtils.getEnergyDisplay((double)((TileEntityReactorController)this.tileEntity).getReactor().getPassiveGeneration(false, true)) + "/t") : new ArrayList(), (IGuiWrapper)this, resource));
        this.addGuiElement((GuiElement)new GuiReactorTab((IGuiWrapper)this, (TileEntityReactorController)this.tileEntity, GuiReactorTab.ReactorTab.HEAT, resource));
        this.addGuiElement((GuiElement)new GuiReactorTab((IGuiWrapper)this, (TileEntityReactorController)this.tileEntity, GuiReactorTab.ReactorTab.FUEL, resource));
        this.addGuiElement((GuiElement)new GuiReactorTab((IGuiWrapper)this, (TileEntityReactorController)this.tileEntity, GuiReactorTab.ReactorTab.STAT, resource));
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.field_146289_q.func_78276_b(((TileEntityReactorController)this.tileEntity).func_70005_c_(), 46, 6, 0x404040);
        this.field_146289_q.func_78276_b("CR", 30, 35, 0x404040);
        this.field_146289_q.func_78276_b("TR", 64, 35, 0x404040);
        this.field_146289_q.func_78276_b("EF", 102, 35, 0x404040);
        this.field_146289_q.func_78276_b("ER", 142, 35, 0x404040);
        this.field_146289_q.func_78276_b(String.format("%.1f", Float.valueOf(((TileEntityReactorController)this.tileEntity).getReactor().getCurrentReactivity())), 30, 45, 0x404040);
        this.field_146289_q.func_78276_b(String.format("%.1f", Float.valueOf(((TileEntityReactorController)this.tileEntity).getReactor().getTargetReactivity())), 64, 45, 0x404040);
        this.field_146289_q.func_78276_b(String.format("%.1f", Float.valueOf(((TileEntityReactorController)this.tileEntity).getReactor().getEfficiency())), 102, 45, 0x404040);
        this.field_146289_q.func_78276_b(String.format("%.1f", Float.valueOf(((TileEntityReactorController)this.tileEntity).getReactor().getErrorLevel())), 142, 45, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize((String)"gui.reactor.heatMultiplier") + ": " + String.format("%.2f", Float.valueOf(((TileEntityReactorController)this.tileEntity).getReactor().getKt() * 10.0f)), 8, 120, 0x404040);
        if (((TileEntityReactorController)this.tileEntity).getReactor().getLaserShootCountdown() == 0) {
            this.laserReadyButton.field_146125_m = true;
        }
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        if (this.laserReadyButton.func_146115_a()) {
            this.displayTooltips(this.laser, xAxis, yAxis);
        } else if (this.helpButton.func_146115_a()) {
            this.displayTooltips(this.help, xAxis, yAxis);
        } else if (this.plusButton.func_146115_a()) {
            this.displayTooltip(LangUtils.localize((String)"gui.reactor.plus_5_reactivity"), xAxis, yAxis);
        } else if (this.minusButton.func_146115_a()) {
            this.displayTooltip(LangUtils.localize((String)"gui.reactor.minus_5_reactivity"), xAxis, yAxis);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.plusButton = new GuiButton(1, this.field_147003_i + 8, this.field_147009_r + 56, 20, 20, "+5");
        this.field_146292_n.add(this.plusButton);
        this.minusButton = new GuiButton(2, this.field_147003_i + 8, this.field_147009_r + 90, 20, 20, "-5");
        this.field_146292_n.add(this.minusButton);
        this.helpButton = new GuiButton(99, this.field_147003_i + 156, this.field_147009_r + 6, 14, 14, "?");
        this.field_146292_n.add(this.helpButton);
        this.laserReadyButton = new GuiButton(98, this.field_147003_i + 8, this.field_147009_r + 130, 120, 16, EnumColor.DARK_GREEN + LangUtils.localize((String)"gui.reactor.laser_ready_button"));
        this.field_146292_n.add(this.laserReadyButton);
        this.updateEnabledButtons();
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.updateEnabledButtons();
    }

    private void updateEnabledButtons() {
        this.plusButton.field_146124_l = ((TileEntityReactorController)this.tileEntity).getReactor().getAdjustment() == 0.0f;
        this.minusButton.field_146124_l = ((TileEntityReactorController)this.tileEntity).getReactor().getAdjustment() == 0.0f;
        this.helpButton.field_146124_l = false;
        this.laserReadyButton.field_146124_l = false;
        if (((TileEntityReactorController)this.tileEntity).getReactor().getLaserShootCountdown() > 0) {
            this.laserReadyButton.field_146125_m = false;
        }
    }

    @Override
    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        switch (guibutton.field_146127_k) {
            case 1: {
                Mekanism.packetHandler.sendToServer((IMessage)new PacketTileEntity.TileEntityMessage((TileEntity)this.tileEntity, TileNetworkList.withContents((Object[])new Object[]{1})));
                break;
            }
            case 2: {
                Mekanism.packetHandler.sendToServer((IMessage)new PacketTileEntity.TileEntityMessage((TileEntity)this.tileEntity, TileNetworkList.withContents((Object[])new Object[]{2})));
            }
        }
    }
}

