/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.client;

import igentuman.bfr.client.gui.GuiReactorController;
import igentuman.bfr.client.gui.GuiReactorEfficiency;
import igentuman.bfr.client.gui.GuiReactorFuel;
import igentuman.bfr.client.gui.GuiReactorHeat;
import igentuman.bfr.client.gui.GuiReactorLogicAdapter;
import igentuman.bfr.client.gui.GuiReactorLogicAdapterInput;
import igentuman.bfr.client.gui.GuiReactorLogicAdapterOutput;
import igentuman.bfr.client.gui.GuiReactorStats;
import igentuman.bfr.client.render.RenderReactor;
import igentuman.bfr.common.BFRBlocks;
import igentuman.bfr.common.BFRCommonProxy;
import igentuman.bfr.common.block.states.BlockStateReactor;
import igentuman.bfr.common.tile.reactor.TileEntityReactorController;
import igentuman.bfr.common.tile.reactor.TileEntityReactorLogicAdapter;
import mekanism.client.render.MekanismRenderer;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BFRClientProxy
extends BFRCommonProxy {
    private static final IStateMapper reactorMapper = new BlockStateReactor.ReactorBlockStateMapper();

    @Override
    public void registerTESRs() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityReactorController.class, (TileEntitySpecialRenderer)new RenderReactor());
    }

    @Override
    public void registerBlockRenders() {
        ModelLoader.setCustomStateMapper((Block)BFRBlocks.Reactor, (IStateMapper)reactorMapper);
        ModelLoader.setCustomStateMapper((Block)BFRBlocks.ReactorGlass, (IStateMapper)reactorMapper);
        for (BlockStateReactor.ReactorBlockType type : BlockStateReactor.ReactorBlockType.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)type.blockType.getBlock()), (int)type.meta, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("bfr", type.func_176610_l()), "inventory"));
        }
    }

    public void registerItemRender(Item item) {
        MekanismRenderer.registerItemRender((String)"bfr", (Item)item);
    }

    @Override
    public void preInit(FMLPreInitializationEvent preEvent) {
        super.preInit(preEvent);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public GuiScreen getClientGui(int ID, EntityPlayer player, World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        switch (ID) {
            case 10: {
                return new GuiReactorController(player.field_71071_by, (TileEntityReactorController)tileEntity);
            }
            case 11: {
                return new GuiReactorHeat(player.field_71071_by, (TileEntityReactorController)tileEntity);
            }
            case 12: {
                return new GuiReactorFuel(player.field_71071_by, (TileEntityReactorController)tileEntity);
            }
            case 13: {
                return new GuiReactorStats(player.field_71071_by, (TileEntityReactorController)tileEntity);
            }
            case 15: {
                return new GuiReactorLogicAdapter(player.field_71071_by, (TileEntityReactorLogicAdapter)tileEntity);
            }
            case 69: {
                return new GuiReactorEfficiency(player.field_71071_by, (TileEntityReactorController)tileEntity);
            }
            case 70: {
                return new GuiReactorLogicAdapterInput(player.field_71071_by, (TileEntityReactorLogicAdapter)tileEntity);
            }
            case 71: {
                return new GuiReactorLogicAdapterOutput(player.field_71071_by, (TileEntityReactorLogicAdapter)tileEntity);
            }
        }
        return null;
    }

    @SubscribeEvent
    public void onStitch(TextureStitchEvent.Pre event) {
    }
}

