/*
 * Decompiled with CFR 0.152.
 */
package org.mcupdater.reconstructor.tile;

import com.google.common.base.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.mcupdater.reconstructor.Reconstructor;
import org.mcupdater.reconstructor.tile.TileRecon;

public class BlockRecon
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private Item itemBlock;

    public BlockRecon() {
        super(Material.field_151573_f);
        this.func_149663_c("reconstructorblock");
        this.setRegistryName(Reconstructor.metadata.modId, "reconstructorblock");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149711_c(10.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(CreativeTabs.field_78028_d);
        this.itemBlock = this.generateItemBlock();
    }

    private ItemBlock generateItemBlock() {
        ItemBlockReconstructor itemBlock = new ItemBlockReconstructor((Block)this);
        return itemBlock;
    }

    public Item getItemBlock() {
        return this.itemBlock;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState blockState, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, blockState, placer, stack);
        world.func_180501_a(pos, blockState.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileRecon) {
            ((TileRecon)tile).setOrientation((EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING));
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileRecon();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileRecon tile = (TileRecon)world.func_175625_s(pos);
        if (player.func_70093_af()) {
            return false;
        }
        if (tile != null) {
            if (!world.field_72995_K) {
                player.openGui((Object)Reconstructor.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumFacing = EnumFacing.func_82600_a((int)meta);
        if (enumFacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumFacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumFacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    private class ItemBlockReconstructor
    extends ItemBlock {
        public ItemBlockReconstructor(Block block) {
            super(block);
            this.func_77655_b("reconstructorblock");
            this.setRegistryName(Reconstructor.metadata.modId, "reconstructorblock");
        }
    }
}

