/*
 * Decompiled with CFR 0.152.
 */
package org.mcupdater.reconstructor.gui;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import org.mcupdater.reconstructor.helpers.StackHelper;
import org.mcupdater.reconstructor.tile.TileRecon;

public class ContainerRecon
extends Container {
    private TileRecon tile;
    private static final EntityEquipmentSlot[] VALID_EQUIPMENT_SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET, EntityEquipmentSlot.OFFHAND};

    public ContainerRecon(final InventoryPlayer inventoryplayer, TileRecon t) {
        int i;
        this.tile = t;
        this.func_75146_a(new Slot((IInventory)t, 0, 80, 41));
        for (i = 0; i < 4; ++i) {
            final EntityEquipmentSlot entityequipmentslot = VALID_EQUIPMENT_SLOTS[i];
            this.func_75146_a(new Slot((IInventory)inventoryplayer, 36 + (3 - i), 8, 8 + i * 18){

                public int func_75219_a() {
                    return 1;
                }

                public boolean func_75214_a(ItemStack itemStack) {
                    if (itemStack.func_190926_b()) {
                        return false;
                    }
                    return itemStack.func_77973_b().isValidArmor(itemStack, entityequipmentslot, (Entity)inventoryplayer.field_70458_d);
                }

                public String func_178171_c() {
                    return ItemArmor.field_94603_a[entityequipmentslot.func_188454_b()];
                }
            });
        }
        this.func_75146_a(new Slot((IInventory)inventoryplayer, 40, 26, 62){

            public int func_75219_a() {
                return 1;
            }

            public boolean func_75214_a(ItemStack itemStack) {
                return !itemStack.func_190926_b();
            }

            public String func_178171_c() {
                return "minecraft:items/empty_armor_slot_shield";
            }
        });
        for (i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.func_75146_a(new Slot((IInventory)inventoryplayer, k + i * 9 + 9, 8 + k * 18, 84 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.func_75146_a(new Slot((IInventory)inventoryplayer, j, 8 + j * 18, 142));
        }
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return this.tile.func_70300_a(entityplayer);
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        ItemStack originalStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        int numSlots = this.field_75151_b.size();
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackInSlot = slot.func_75211_c();
            originalStack = stackInSlot.func_77946_l();
            if ((slotIndex < numSlots - 36 || !this.tryShiftItem(stackInSlot, numSlots)) && (slotIndex >= numSlots - 36 && slotIndex < numSlots - 9 ? !this.shiftItemStack(stackInSlot, numSlots - 9, numSlots) : (slotIndex >= numSlots - 9 && slotIndex < numSlots ? !this.shiftItemStack(stackInSlot, numSlots - 36, numSlots - 9) : !this.shiftItemStack(stackInSlot, numSlots - 36, numSlots)))) {
                return ItemStack.field_190927_a;
            }
            slot.func_75220_a(stackInSlot, originalStack);
            if (stackInSlot.func_190916_E() <= 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stackInSlot.func_190916_E() == originalStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, stackInSlot);
        }
        return originalStack;
    }

    protected boolean shiftItemStack(ItemStack stackToShift, int start, int end) {
        ItemStack stackInSlot;
        Slot slot;
        int slotIndex;
        boolean changed = false;
        if (stackToShift.func_77985_e()) {
            for (slotIndex = start; stackToShift.func_190916_E() > 0 && slotIndex < end; ++slotIndex) {
                int max;
                slot = (Slot)this.field_75151_b.get(slotIndex);
                stackInSlot = slot.func_75211_c();
                if (stackInSlot.func_190926_b() || !StackHelper.instance().canStacksMerge(stackInSlot, stackToShift)) continue;
                int resultingStackSize = stackInSlot.func_190916_E() + stackToShift.func_190916_E();
                if (resultingStackSize <= (max = Math.min(stackToShift.func_77976_d(), slot.func_75219_a()))) {
                    stackToShift.func_190920_e(0);
                    stackInSlot.func_190920_e(resultingStackSize);
                    slot.func_75218_e();
                    changed = true;
                    continue;
                }
                if (stackInSlot.func_190916_E() >= max) continue;
                stackToShift.func_190920_e(stackToShift.func_190916_E() - max - stackInSlot.func_190916_E());
                stackInSlot.func_190920_e(max);
                slot.func_75218_e();
                changed = true;
            }
        }
        if (stackToShift.func_190916_E() > 0) {
            for (slotIndex = start; stackToShift.func_190916_E() > 0 && slotIndex < end; ++slotIndex) {
                slot = (Slot)this.field_75151_b.get(slotIndex);
                stackInSlot = slot.func_75211_c();
                if (!stackInSlot.func_190926_b()) continue;
                int max = Math.min(stackToShift.func_77976_d(), slot.func_75219_a());
                stackInSlot = stackToShift.func_77946_l();
                stackInSlot.func_190920_e(Math.min(stackToShift.func_190916_E(), max));
                stackToShift.func_190920_e(stackToShift.func_190916_E() - stackInSlot.func_190916_E());
                slot.func_75215_d(stackInSlot);
                slot.func_75218_e();
                changed = true;
            }
        }
        return changed;
    }

    private boolean tryShiftItem(ItemStack stackToShift, int numSlots) {
        for (int machineIndex = 0; machineIndex < numSlots - 36; ++machineIndex) {
            Slot slot = (Slot)this.field_75151_b.get(machineIndex);
            if (!slot.func_75214_a(stackToShift) || !this.shiftItemStack(stackToShift, machineIndex, machineIndex + 1)) continue;
            return true;
        }
        return false;
    }
}

