/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.compat.computers;

import java.util.ArrayList;
import li.cil.oc.api.internal.Database;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.prefab.AbstractManagedEnvironment;
import mcjty.lib.integration.computers.AbstractOCDriver;
import mcjty.lib.varia.RedstoneMode;
import mcjty.rftools.blocks.crafter.CrafterBaseTE;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CrafterDriver {

    public static class OCDriver
    extends AbstractOCDriver {
        public OCDriver() {
            super("rftools_crafter", CrafterBaseTE.class);
        }

        public AbstractManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing side, TileEntity tile) {
            return new InternalManagedEnvironment((CrafterBaseTE)tile);
        }

        public static class InternalManagedEnvironment
        extends AbstractOCDriver.InternalManagedEnvironment<CrafterBaseTE> {
            public InternalManagedEnvironment(CrafterBaseTE tile) {
                super((Object)tile, "rftools_crafter");
            }

            @Callback(doc="function():number; Get the currently stored energy")
            public Object[] getEnergy(Context c, Arguments a) {
                return new Object[]{((CrafterBaseTE)this.tile).getStoredPower()};
            }

            @Callback(doc="function():number; Get the maximum stored energy")
            public Object[] getMaxEnergy(Context c, Arguments a) {
                return new Object[]{((CrafterBaseTE)this.tile).getCapacity()};
            }

            @Callback(doc="function():string; Get the current redstone mode. One of \"Ignored\", \"Off\" and \"On\"")
            public Object[] getRedstoneMode(Context c, Arguments a) {
                return new Object[]{((CrafterBaseTE)this.tile).getRSMode().getDescription()};
            }

            @Callback(doc="function(rsMode:string); Set the redstone mode. One of \"Ignored\", \"Off\" and \"On\"")
            public Object[] setRedstoneMode(Context c, Arguments a) {
                String newVal = a.checkString(0);
                RedstoneMode rsMode = RedstoneMode.getMode((String)newVal);
                if (rsMode != null) {
                    ((CrafterBaseTE)this.tile).setRSMode(rsMode);
                    ((CrafterBaseTE)this.tile).markDirtyClient();
                    return new Object[]{true};
                }
                return new Object[]{false, "Not a valid redstone mode. Needs to be one of \"Ignored\", \"Off\" and \"On\""};
            }

            @Callback(doc="function():number; Get the speed mode, the returned value will either be 0 (slow), or 1 (fast)")
            public Object[] getSpeedMode(Context c, Arguments a) {
                return new Object[]{((CrafterBaseTE)this.tile).getSpeedMode()};
            }

            @Callback(doc="function(mode:number):bool; Set the speed mode. One of 0 (slow), or 1 (fast)")
            public Object[] setSpeedMode(Context c, Arguments a) {
                int mode = a.checkInteger(0);
                if (mode < 0 || mode > 1) {
                    return new Object[]{false, "Not a valid speed mode. Needs to be one of 0 (slow), or 1 (fast)"};
                }
                ((CrafterBaseTE)this.tile).setSpeedMode(mode);
                return new Object[]{true};
            }

            @Callback(doc="function():number; Get the number of supported recipes")
            public Object[] getSupportedRecipes(Context c, Arguments a) {
                return new Object[]{((CrafterBaseTE)this.tile).getSupportedRecipes()};
            }

            @Callback(doc="function(recipeIndex:number):table; Gets the recipe at the specified index")
            public Object[] getRecipe(Context c, Arguments a) {
                int index = a.checkInteger(0) - 1;
                if (index < 0 || index > ((CrafterBaseTE)this.tile).getSupportedRecipes()) {
                    return new Object[]{null, "Invalid index"};
                }
                ArrayList<ItemStack> ingredientList = new ArrayList<ItemStack>();
                InventoryCrafting inv = ((CrafterBaseTE)this.tile).getRecipe(index).getInventory();
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ingredientList.add(inv.func_70301_a(i).func_77946_l());
                }
                return new Object[]{ingredientList};
            }

            @Callback(doc="function(recipeIndex:number):table; Gets the result of the recipe at the specified index")
            public Object[] getRecipeResult(Context c, Arguments a) {
                int index = a.checkInteger(0) - 1;
                if (index < 0 || index > ((CrafterBaseTE)this.tile).getSupportedRecipes()) {
                    return new Object[]{null, "Invalid index"};
                }
                return new Object[]{((CrafterBaseTE)this.tile).getRecipe(index).getResult()};
            }

            @Callback(doc="function(recipeIndex:number):bool; Returns whether an item is kept in the input slots for the specified recipe")
            public Object[] getKeepOne(Context c, Arguments a) {
                int index = a.checkInteger(0) - 1;
                if (index < 0 || index > ((CrafterBaseTE)this.tile).getSupportedRecipes()) {
                    return new Object[]{null, "Invalid index"};
                }
                return new Object[]{((CrafterBaseTE)this.tile).getRecipe(index).isKeepOne()};
            }

            @Callback(doc="function(recipeIndex:number):string; Gets the craft mode for the specified recipe, one of \"Int\", \"Ext\", or \"ExtC\"")
            public Object[] getCraftMode(Context c, Arguments a) {
                int index = a.checkInteger(0) - 1;
                if (index < 0 || index > ((CrafterBaseTE)this.tile).getSupportedRecipes()) {
                    return new Object[]{null, "Invalid index"};
                }
                return new Object[]{((CrafterBaseTE)this.tile).getRecipe(index).getCraftMode().getDescription()};
            }

            @Callback(doc="function(recipeIndex:number, database:address, slot:number)bool; Store a recipe in a database, starting from the given slot number")
            public Object[] storeRecipeInDB(Context c, Arguments a) {
                int index = a.checkInteger(0) - 1;
                if (index < 0 || index > ((CrafterBaseTE)this.tile).getSupportedRecipes()) {
                    return new Object[]{false, "Invalid index"};
                }
                String address = a.checkString(1);
                Node databaseNode = this.node().network().node(address);
                if (databaseNode == null) {
                    return new Object[]{false, "given component address does not exist"};
                }
                Environment databaseEnvironment = databaseNode.host();
                if (databaseEnvironment == null || !(databaseEnvironment instanceof Database)) {
                    return new Object[]{false, "given component is not a database"};
                }
                InventoryCrafting inv = ((CrafterBaseTE)this.tile).getRecipe(index).getInventory();
                Database database = (Database)databaseEnvironment;
                if (database.size() < inv.func_70302_i_()) {
                    return new Object[]{false, "Not enough slots in database for recipe"};
                }
                int slot = a.checkInteger(2) - 1;
                if (slot < 0 || slot >= database.size()) {
                    return new Object[]{false, "Slot index out of bounds"};
                }
                if (database.size() - inv.func_70302_i_() < slot) {
                    return new Object[]{false, "Not enough slots available from given slot number to end of database"};
                }
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    database.setStackInSlot(slot, inv.func_70301_a(i).func_77946_l());
                    ++slot;
                }
                return new Object[]{true};
            }

            @Callback(doc="function(recipeIndex:number, database:address, slot:number)bool; Store a recipe result in a database, at the given slot number")
            public Object[] storeRecipeResultInDB(Context c, Arguments a) {
                int index = a.checkInteger(0) - 1;
                if (index < 0 || index > ((CrafterBaseTE)this.tile).getSupportedRecipes()) {
                    return new Object[]{false, "Invalid index"};
                }
                String address = a.checkString(1);
                Node databaseNode = this.node().network().node(address);
                if (databaseNode == null) {
                    return new Object[]{false, "given component address does not exist"};
                }
                Environment databaseEnvironment = databaseNode.host();
                if (databaseEnvironment == null || !(databaseEnvironment instanceof Database)) {
                    return new Object[]{false, "given component is not a database"};
                }
                Database database = (Database)databaseEnvironment;
                int slot = a.checkInteger(2) - 1;
                if (slot < 0 || slot >= database.size()) {
                    return new Object[]{false, "Slot index out of bounds"};
                }
                database.setStackInSlot(slot, ((CrafterBaseTE)this.tile).getRecipe(index).getResult().func_77946_l());
                return new Object[]{true};
            }

            public int priority() {
                return 4;
            }
        }
    }
}

