/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.handler.capabilities;

import asmodeuscore.core.astronomy.SpaceData;
import asmodeuscore.core.handler.capabilities.ACCapabilityStatsHandler;
import asmodeuscore.core.handler.capabilities.IStatsCapability;
import java.lang.ref.WeakReference;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class ACStatsCapability
implements IStatsCapability {
    public WeakReference<EntityPlayerMP> player;
    public int buildFlags = 0;
    public SpaceData.Engine_Type rocket_engine = SpaceData.Engine_Type.FUEL_ENGINE;
    private boolean isSecondPassenger;

    public static IStatsCapability get(Entity entity) {
        return (IStatsCapability)entity.getCapability(ACCapabilityStatsHandler.AC_STATS_CAPABILITY, null);
    }

    @Override
    public void saveNBTData(NBTTagCompound nbt) {
        nbt.func_74768_a("rocket_engine", this.getEngineType().getID());
        nbt.func_74757_a("SecondPassenger", this.isSecondPassenger);
    }

    @Override
    public void loadNBTData(NBTTagCompound nbt) {
        try {
            this.rocket_engine = SpaceData.Engine_Type.byID(nbt.func_74762_e("rocket_engine"));
            this.isSecondPassenger = nbt.func_74767_n("SecondPassenger");
        }
        catch (Exception e) {
            GCLog.severe((String)("Found error in saved AsmodeusCore player data for " + ((EntityPlayerMP)this.player.get()).func_146103_bH().getName() + " - this should fix itself next relog."));
            e.printStackTrace();
        }
        GCLog.debug((String)("Finished loading AsmodeusCore player data for " + ((EntityPlayerMP)this.player.get()).func_146103_bH().getName() + " : " + this.buildFlags));
    }

    @Override
    public void copyFrom(IStatsCapability oldData, boolean keepInv) {
        this.rocket_engine = oldData.getEngineType();
        this.isSecondPassenger = oldData.isSecondPassenger();
    }

    @Override
    public WeakReference<EntityPlayerMP> getPlayer() {
        return this.player;
    }

    @Override
    public void setPlayer(WeakReference<EntityPlayerMP> player) {
        this.player = player;
    }

    @Override
    public void setEngineType(SpaceData.Engine_Type type) {
        this.rocket_engine = type;
    }

    @Override
    public SpaceData.Engine_Type getEngineType() {
        return this.rocket_engine;
    }

    @Override
    public boolean isSecondPassenger() {
        return this.isSecondPassenger;
    }

    @Override
    public void setSecondPassenger(boolean b) {
        this.isSecondPassenger = b;
    }
}

