/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.handler;

import asmodeuscore.api.blocks.ICustomLeaves;
import asmodeuscore.core.utils.worldengine.WE_Biome;
import asmodeuscore.core.utils.worldengine.WE_ChunkProvider;
import asmodeuscore.core.utils.worldengine.WE_WorldProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ColorBlockHandler {
    private static List<IBlockState> blocks = new ArrayList<IBlockState>();
    private static List<IBlockState> leaves = new ArrayList<IBlockState>();
    private static List<IBlockState> water_blocks = new ArrayList<IBlockState>();
    private static Map<IBlockState, Integer> color_blocks = new HashMap<IBlockState, Integer>();
    public static World world;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerBlockColourHandlers(ColorHandlerEvent.Block event) {
        BlockColors blockColors = event.getBlockColors();
        IBlockColor grassColourHandler = (state, blockAccess, pos, tintIndex) -> {
            if (blockAccess != null && pos != null) {
                WE_ChunkProvider chunk;
                if (world != null && ColorBlockHandler.world.field_73011_w instanceof WE_WorldProvider && (chunk = ((WE_WorldProvider)ColorBlockHandler.world.field_73011_w).chunk_provider) != null && ((WE_WorldProvider)ColorBlockHandler.world.field_73011_w).isColorWorld()) {
                    return WE_Biome.getBiomeAt((WE_ChunkProvider)chunk, (long)((long)pos.func_177958_n()), (long)((long)pos.func_177952_p())).biomeBlockGrassColor;
                }
                return BiomeColorHelper.func_180286_a((IBlockAccess)blockAccess, (BlockPos)pos);
            }
            return ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
        };
        for (IBlockState iBlockState : blocks) {
            blockColors.func_186722_a(grassColourHandler, new Block[]{iBlockState.func_177230_c()});
        }
        IBlockColor leavesColourHandler = (state, blockAccess, pos, tintIndex) -> {
            if (blockAccess != null && pos != null) {
                WE_ChunkProvider chunk;
                if (world != null && ColorBlockHandler.world.field_73011_w instanceof WE_WorldProvider && (chunk = ((WE_WorldProvider)ColorBlockHandler.world.field_73011_w).chunk_provider) != null) {
                    return WE_Biome.getBiomeAt((WE_ChunkProvider)chunk, (long)((long)pos.func_177958_n()), (long)((long)pos.func_177952_p())).biomeBlockLeavesColor;
                }
                if (state.func_177230_c() == Blocks.field_150362_t) {
                    BlockPlanks.EnumType blockplanks$enumtype = (BlockPlanks.EnumType)state.func_177229_b((IProperty)BlockOldLeaf.field_176239_P);
                    if (blockplanks$enumtype == BlockPlanks.EnumType.SPRUCE) {
                        return ColorizerFoliage.func_77466_a();
                    }
                    if (blockplanks$enumtype == BlockPlanks.EnumType.BIRCH) {
                        return ColorizerFoliage.func_77469_b();
                    }
                    return BiomeColorHelper.func_180287_b((IBlockAccess)blockAccess, (BlockPos)pos);
                }
                if (state.func_177230_c() == Blocks.field_150361_u) {
                    return BiomeColorHelper.func_180287_b((IBlockAccess)blockAccess, (BlockPos)pos);
                }
            }
            if (state.func_177230_c() instanceof ICustomLeaves) {
                return ((ICustomLeaves)state.func_177230_c()).getDefaultLeavesColor();
            }
            return ColorizerFoliage.func_77468_c();
        };
        for (IBlockState iBlockState : leaves) {
            blockColors.func_186722_a(leavesColourHandler, new Block[]{iBlockState.func_177230_c()});
        }
        for (Map.Entry<IBlockState, Integer> entry : color_blocks.entrySet()) {
            IBlockColor colorHandler = (state, blockAccess, pos, tintIndex) -> (Integer)color_blocks.getValue();
            blockColors.func_186722_a(colorHandler, new Block[]{entry.getKey().func_177230_c()});
        }
        IBlockColor iBlockColor = (state, blockAccess, pos, tintIndex) -> {
            if (blockAccess != null && pos != null) {
                WE_Biome biome;
                WE_ChunkProvider chunk;
                if (world != null && ColorBlockHandler.world.field_73011_w instanceof WE_WorldProvider && (chunk = ((WE_WorldProvider)ColorBlockHandler.world.field_73011_w).chunk_provider) != null && (biome = WE_Biome.getBiomeAt(chunk, pos.func_177958_n(), pos.func_177952_p())) != null) {
                    return biome.biomeBlockWaterColor;
                }
                return BiomeColorHelper.func_180288_c((IBlockAccess)blockAccess, (BlockPos)pos);
            }
            return ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
        };
        for (IBlockState block : water_blocks) {
            blockColors.func_186722_a(iBlockColor, new Block[]{block.func_177230_c()});
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerItemColourHandlers(ColorHandlerEvent.Item event) {
        BlockColors blockColors = event.getBlockColors();
        ItemColors itemColors = event.getItemColors();
        IItemColor itemBlockColourHandler = (stack, tintIndex) -> {
            if (stack.func_77973_b() instanceof ItemBlock) {
                IBlockState state = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
                return blockColors.func_186724_a(state, null, null, tintIndex);
            }
            return itemColors.func_186728_a(stack, tintIndex);
        };
        for (IBlockState block : blocks) {
            itemColors.func_186731_a(itemBlockColourHandler, new Block[]{block.func_177230_c()});
        }
        for (IBlockState block : leaves) {
            itemColors.func_186731_a(itemBlockColourHandler, new Block[]{block.func_177230_c()});
        }
    }

    public static void addBlock(IBlockState block) {
        if (!blocks.contains(block)) {
            blocks.add(block);
        }
    }

    public static void addLeavesBlock(IBlockState block) {
        if (!leaves.contains(block)) {
            leaves.add(block);
        }
    }

    public static void addBlockWithColor(IBlockState block, int color) {
        if (!color_blocks.containsKey(block)) {
            color_blocks.put(block, color);
        }
    }

    public static void addWaterBlock(IBlockState block) {
        if (!water_blocks.contains(block)) {
            water_blocks.add(block);
        }
    }
}

