/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.astronomy.dimension.world.worldengine.biome;

import asmodeuscore.core.utils.worldengine.WE_Biome;
import asmodeuscore.core.utils.worldengine.additions.WE_CreateChunkGen_InXZ;
import asmodeuscore.core.utils.worldengine.standardcustomgen.WE_BiomeLayer;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedEnderman;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WE_BaseBiome
extends WE_Biome {
    private static int[] colors = new int[]{52224, 0xFFFFFF, 52224};

    public WE_BaseBiome(double max, double persistance, int octaves, int height, int intquility, WE_BiomeLayer layers, IWorldGenerator ... gens) {
        this(0.0, max, persistance, octaves, height, intquility, layers, gens);
        this.setAbsoluteValue();
    }

    public WE_BaseBiome(double min, double max, double persistance, int octaves, int height, int intquility, WE_BiomeLayer layers, IWorldGenerator ... gens) {
        super(new Biome.BiomeProperties("we_basebiome"), colors);
        this.biomeMinValueOnMap = min;
        this.biomeMaxValueOnMap = max;
        this.biomePersistence = persistance;
        this.biomeNumberOfOctaves = octaves;
        this.biomeScaleX = 280.0;
        this.biomeScaleY = 1.5;
        this.biomeSurfaceHeight = height;
        this.biomeInterpolateQuality = intquility;
        this.decorateChunkGen_List.clear();
        this.createChunkGen_InXZ_List.clear();
        this.field_76761_J.clear();
        this.field_82914_M.clear();
        this.field_76762_K.clear();
        this.field_76755_L.clear();
        if (layers != null) {
            this.createChunkGen_InXZ_List.add(layers);
        }
        for (IWorldGenerator gen : gens) {
            this.decorateChunkGen_List.add(gen);
        }
    }

    public WE_BaseBiome setColors(int grass, int water, int leaves) {
        this.biomeBlockGrassColor = grass;
        this.biomeBlockWaterColor = water;
        this.biomeBlockLeavesColor = leaves;
        return this;
    }

    public WE_BaseBiome setSize(double x, double y) {
        this.biomeScaleX = x;
        this.biomeScaleY = y;
        return this;
    }

    public WE_BaseBiome addChunkGen(WE_CreateChunkGen_InXZ gen) {
        this.createChunkGen_InXZ_List.add(gen);
        return this;
    }

    public WE_BaseBiome setPrelinNoiseID(int id) {
        this.biomeNumNoise = id;
        return this;
    }

    public WE_BaseBiome setBaseSpawn() {
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEvolvedSpider.class, 10, 1, 2));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEvolvedSkeleton.class, 10, 1, 2));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEvolvedZombie.class, 10, 1, 2));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEvolvedEnderman.class, 10, 1, 2));
        return this;
    }
}

