/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.astronomy.dimension.world.gen.dungeons.standart;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class DungeonConfiguration {
    private IBlockState brickBlock;
    private IBlockState topBlock;
    private IBlockState floorBlock;
    private int yPosition;
    private int hallwayLengthMin;
    private int hallwayLengthMax;
    private int hallwayHeight;
    private int roomHeight;
    private Class<?> corridor;
    private Class<?> emptyRoom;
    private Class<?> spawnerRoom;
    private Class<?> chestRoom;
    private Class<?> bossRoom;
    private Class<?> treasureRoom;

    public DungeonConfiguration() {
    }

    public DungeonConfiguration(IBlockState brickBlock, IBlockState topBlock, IBlockState floorBlock, int yPosition, int hallwayLengthMin, int hallwayLengthMax, int hallwayHeight, int roomHeight, Class<?> corridor, Class<?> emptyRoom, Class<?> spawnerRoom, Class<?> chestRoom, Class<?> bossRoom, Class<?> treasureRoom) {
        this.brickBlock = brickBlock;
        this.topBlock = topBlock;
        this.floorBlock = floorBlock;
        this.yPosition = yPosition;
        this.hallwayLengthMin = hallwayLengthMin;
        this.hallwayLengthMax = hallwayLengthMax;
        this.hallwayHeight = hallwayHeight;
        this.roomHeight = roomHeight;
        this.corridor = corridor;
        this.emptyRoom = emptyRoom;
        this.spawnerRoom = spawnerRoom;
        this.chestRoom = chestRoom;
        this.bossRoom = bossRoom;
        this.treasureRoom = treasureRoom;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74778_a("brickBlock", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.brickBlock.func_177230_c())).toString());
        tagCompound.func_74768_a("brickBlockMeta", this.brickBlock.func_177230_c().func_176201_c(this.brickBlock));
        if (this.topBlock != null) {
            tagCompound.func_74778_a("topBlock", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.topBlock.func_177230_c())).toString());
            tagCompound.func_74768_a("topBlockMeta", this.topBlock.func_177230_c().func_176201_c(this.topBlock));
        }
        if (this.floorBlock != null) {
            tagCompound.func_74778_a("floorBlock", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.floorBlock.func_177230_c())).toString());
            tagCompound.func_74768_a("floorBlockMeta", this.floorBlock.func_177230_c().func_176201_c(this.floorBlock));
        }
        tagCompound.func_74768_a("yPosition", this.yPosition);
        tagCompound.func_74768_a("hallwayLengthMin", this.hallwayLengthMin);
        tagCompound.func_74768_a("hallwayLengthMax", this.hallwayLengthMax);
        tagCompound.func_74768_a("hallwayHeight", this.hallwayHeight);
        tagCompound.func_74768_a("roomHeight", this.roomHeight);
        if (this.corridor != null) {
            tagCompound.func_74778_a("corridor", this.corridor.getName());
        }
        if (this.emptyRoom != null) {
            tagCompound.func_74778_a("emptyRoom", this.emptyRoom.getName());
        }
        if (this.spawnerRoom != null) {
            tagCompound.func_74778_a("spawnerRoom", this.spawnerRoom.getName());
        }
        if (this.chestRoom != null) {
            tagCompound.func_74778_a("chestRoom", this.chestRoom.getName());
        }
        tagCompound.func_74778_a("bossRoom", this.bossRoom.getName());
        tagCompound.func_74778_a("treasureRoom", this.treasureRoom.getName());
        return tagCompound;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        try {
            this.brickBlock = Block.func_149684_b((String)tagCompound.func_74779_i("brickBlock")).func_176203_a(tagCompound.func_74762_e("brickBlockMeta"));
            if (this.topBlock != null) {
                this.topBlock = Block.func_149684_b((String)tagCompound.func_74779_i("topBlock")).func_176203_a(tagCompound.func_74762_e("topBlockMeta"));
            }
            if (this.floorBlock != null) {
                this.floorBlock = Block.func_149684_b((String)tagCompound.func_74779_i("floorBlock")).func_176203_a(tagCompound.func_74762_e("floorBlockMeta"));
            }
            this.yPosition = tagCompound.func_74762_e("yPosition");
            this.hallwayLengthMin = tagCompound.func_74762_e("hallwayLengthMin");
            this.hallwayLengthMax = tagCompound.func_74762_e("hallwayLengthMax");
            this.hallwayHeight = tagCompound.func_74762_e("hallwayHeight");
            this.roomHeight = tagCompound.func_74762_e("roomHeight");
            if (this.corridor != null) {
                this.corridor = Class.forName(tagCompound.func_74779_i("corridor"));
            }
            if (this.emptyRoom != null) {
                this.emptyRoom = Class.forName(tagCompound.func_74779_i("emptyRoom"));
            }
            if (this.spawnerRoom != null) {
                this.spawnerRoom = Class.forName(tagCompound.func_74779_i("spawnerRoom"));
            }
            if (this.chestRoom != null) {
                this.chestRoom = Class.forName(tagCompound.func_74779_i("chestRoom"));
            }
            this.bossRoom = Class.forName(tagCompound.func_74779_i("bossRoom"));
            this.treasureRoom = Class.forName(tagCompound.func_74779_i("treasureRoom"));
        }
        catch (Exception e) {
            System.err.println("Failed to read dungeon configuration from NBT");
            e.printStackTrace();
        }
    }

    public IBlockState getBrickBlock() {
        return this.brickBlock;
    }

    public IBlockState getOtherBlock(boolean floor) {
        if (floor) {
            return this.floorBlock;
        }
        return this.topBlock;
    }

    public int getYPosition() {
        return this.yPosition;
    }

    public int getHallwayLengthMin() {
        return this.hallwayLengthMin;
    }

    public int getHallwayLengthMax() {
        return this.hallwayLengthMax;
    }

    public int getHallwayHeight() {
        return this.hallwayHeight;
    }

    public int getRoomHeight() {
        return this.roomHeight;
    }

    public Class<?> getCorridor() {
        return this.corridor;
    }

    public Class<?> getEmptyRoom() {
        return this.emptyRoom;
    }

    public Class<?> getSpawnerRoom() {
        return this.spawnerRoom;
    }

    public Class<?> getChestRoom() {
        return this.chestRoom;
    }

    public Class<?> getBossRoom() {
        return this.bossRoom;
    }

    public Class<?> getTreasureRoom() {
        return this.treasureRoom;
    }
}

