/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.deepresonance.blocks.crystals.ResonatingCrystalTileEntity;
import mcjty.deepresonance.network.DRMessages;
import mcjty.deepresonance.network.PacketReturnCrystalInfo;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketGetCrystalInfo
implements IMessage {
    private BlockPos pos;

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
    }

    public PacketGetCrystalInfo() {
    }

    public PacketGetCrystalInfo(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketGetCrystalInfo(BlockPos pos) {
        this.pos = pos;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            World world = ctx.getSender().func_130014_f_();
            TileEntity tileEntity = world.func_175625_s(this.pos);
            if (tileEntity instanceof ResonatingCrystalTileEntity) {
                ResonatingCrystalTileEntity resonatingCrystalTileEntity = (ResonatingCrystalTileEntity)tileEntity;
                PacketReturnCrystalInfo packet = new PacketReturnCrystalInfo(resonatingCrystalTileEntity.getRfPerTick(), resonatingCrystalTileEntity.getPower());
                DRMessages.INSTANCE.sendTo((IMessage)packet, ctx.getSender());
            }
        });
        ctx.setPacketHandled(true);
    }
}

