/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.config;

import java.io.File;
import mcjty.deepresonance.DeepResonance;
import mcjty.deepresonance.blocks.generator.GeneratorConfiguration;
import mcjty.deepresonance.blocks.laser.LaserBonusConfiguration;
import mcjty.deepresonance.radiation.RadiationConfiguration;
import mcjty.deepresonance.radiation.SuperGenerationConfiguration;
import mcjty.deepresonance.worldgen.WorldGenConfiguration;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class ConfigSetup {
    private static Configuration mainConfig;

    public static void init() {
        File modConfigDir = new File(DeepResonance.setup.getModConfigDir().getPath() + File.separator + "deepresonance");
        Configuration cfg = mainConfig = new Configuration(new File(modConfigDir, "main.cfg"));
        try {
            cfg.load();
            cfg.addCustomCategoryComment("worldgen", "Configuration for worldgen");
            cfg.addCustomCategoryComment("generator", "Configuration for the generator multiblock");
            cfg.addCustomCategoryComment("radiation", "Configuration for the radiation");
            cfg.addCustomCategoryComment("laserconfig", "Configuration for the laser bonuses");
            cfg.addCustomCategoryComment("supergen", "Configuration for super power generation (using pulser)");
            WorldGenConfiguration.init(cfg);
            GeneratorConfiguration.init(cfg);
            RadiationConfiguration.init(cfg);
            LaserBonusConfiguration.init(cfg);
            SuperGenerationConfiguration.init(cfg);
        }
        catch (Exception e1) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e1, (String)"Problem loading config file!", (Object[])new Object[0]);
        }
        finally {
            if (mainConfig.hasChanged()) {
                mainConfig.save();
            }
        }
    }

    public static void postInit() {
        if (mainConfig.hasChanged()) {
            mainConfig.save();
        }
    }
}

