/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.commands;

import java.util.Map;
import mcjty.deepresonance.blocks.ModBlocks;
import mcjty.deepresonance.blocks.debug.DebugBlock;
import mcjty.deepresonance.commands.AbstractDRCommand;
import mcjty.deepresonance.radiation.DRRadiationManager;
import mcjty.deepresonance.varia.QuadTree;
import mcjty.lib.varia.GlobalCoordinate;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class CmdShowRadiation
extends AbstractDRCommand {
    @Override
    public String getHelp() {
        return "<level>";
    }

    @Override
    public String getCommand() {
        return "showradiation";
    }

    @Override
    public int getPermissionLevel() {
        return 2;
    }

    @Override
    public void execute(ICommandSender sender, String[] args) {
        if (args.length > 2) {
            TextComponentString component = new TextComponentString(TextFormatting.RED + "Too many parameters!");
            if (sender instanceof EntityPlayer) {
                ((EntityPlayer)sender).func_146105_b((ITextComponent)component, false);
            } else {
                sender.func_145747_a((ITextComponent)component);
            }
            return;
        }
        float level = this.fetchFloat(sender, args, 1, 0.0f);
        World world = sender.func_130014_f_();
        DRRadiationManager manager = DRRadiationManager.getManager(world);
        Map<GlobalCoordinate, DRRadiationManager.RadiationSource> sources = manager.getRadiationSources();
        for (Map.Entry<GlobalCoordinate, DRRadiationManager.RadiationSource> entry : sources.entrySet()) {
            GlobalCoordinate c = entry.getKey();
            if (c.getDimension() != world.field_73011_w.getDimension()) continue;
            DRRadiationManager.RadiationSource source = entry.getValue();
            int cx = c.getCoordinate().func_177958_n();
            int cy = c.getCoordinate().func_177956_o();
            int cz = c.getCoordinate().func_177952_p();
            int radius = (int)source.getRadius();
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int x = cx - radius; x < cx + radius; ++x) {
                for (int y = cy - radius; y < cy + radius; ++y) {
                    for (int z = cz - radius; z < cz + radius; ++z) {
                        pos.func_181079_c(x, y, z);
                        Block b = world.func_180495_p((BlockPos)pos).func_177230_c();
                        if (!world.func_175623_d((BlockPos)pos) && b != ModBlocks.debugBlock) continue;
                        QuadTree radiationTree = source.getRadiationTree(world, cx, cy, cz);
                        float rad = (float)radiationTree.factor(cx, cy, cz, x, y, z);
                        double distanceSq = pos.func_177951_i((Vec3i)c.getCoordinate());
                        double distance = Math.sqrt(distanceSq);
                        float strength = (float)((double)source.getStrength() * ((double)radius - distance) / (double)radius) * rad;
                        if (level < 0.0f) {
                            if (strength < -level && strength > 10.0f) {
                                world.func_180501_a((BlockPos)pos, ModBlocks.debugBlock.func_176223_P().func_177226_a((IProperty)DebugBlock.STATUS, (Comparable)Integer.valueOf(1)), 3);
                                continue;
                            }
                            world.func_175698_g((BlockPos)pos);
                            continue;
                        }
                        if (strength >= level * 2.0f) {
                            world.func_180501_a((BlockPos)pos, ModBlocks.debugBlock.func_176223_P().func_177226_a((IProperty)DebugBlock.STATUS, (Comparable)Integer.valueOf(0)), 3);
                            continue;
                        }
                        if (strength >= level) {
                            world.func_180501_a((BlockPos)pos, ModBlocks.debugBlock.func_176223_P().func_177226_a((IProperty)DebugBlock.STATUS, (Comparable)Integer.valueOf(2)), 3);
                            continue;
                        }
                        world.func_175698_g((BlockPos)pos);
                    }
                }
            }
        }
    }
}

