/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.ynot.traits;

import java.util.Map;
import mcjty.xnet.api.gui.IEditorGui;
import net.minecraft.nbt.NBTTagCompound;
import pl.asie.ynot.traits.TraitInteger;

public class TraitIntegerChoices
extends TraitInteger {
    private String[] choiceStrs;
    private int[] choices;

    public TraitIntegerChoices(String tag, int[] choices) {
        super(tag, choices[0]);
        this.setChoices(choices);
    }

    public void setChoices(int[] c) {
        this.choices = c;
        this.choiceStrs = new String[c.length];
        for (int i = 0; i < c.length; ++i) {
            this.choiceStrs[i] = Integer.toString(c[i]);
        }
        this.validate();
    }

    protected void validate() {
        if (this.val != null) {
            for (int i = 0; i < this.choices.length; ++i) {
                if (this.val != this.choices[i]) continue;
                return;
            }
        }
        this.val = this.choices[0];
    }

    @Override
    public void readFromNBT(NBTTagCompound cpt) {
        super.readFromNBT(cpt);
        this.validate();
    }

    @Override
    public void update(Map<String, Object> data) {
        if (data.containsKey(this.tag)) {
            this.val = Integer.parseInt((String)data.get(this.tag));
        }
        this.validate();
    }

    @Override
    public IEditorGui apply(String tip, IEditorGui gui) {
        this.validate();
        return gui.choices(this.tag, tip, Integer.toString(this.val), this.choiceStrs);
    }
}

