/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.manager;

import codechicken.wirelessredstone.device.Remote;
import codechicken.wirelessredstone.device.Sniffer;
import codechicken.wirelessredstone.entity.EntityREP;
import codechicken.wirelessredstone.manager.RedstoneEther;
import codechicken.wirelessredstone.manager.RedstoneEtherClientAddons;
import codechicken.wirelessredstone.manager.RedstoneEtherServerAddons;
import codechicken.wirelessredstone.util.WirelessMapNodeStorage;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class RedstoneEtherAddons {
    private static RedstoneEtherClientAddons clientManager;
    private static RedstoneEtherServerAddons serverManager;

    public static RedstoneEtherAddons get(boolean remote) {
        return remote ? clientManager : serverManager;
    }

    public static RedstoneEtherServerAddons server() {
        return serverManager;
    }

    @SideOnly(value=Side.CLIENT)
    public static RedstoneEtherClientAddons client() {
        if (clientManager == null) {
            RedstoneEtherAddons.loadClientManager();
        }
        return clientManager;
    }

    public static void loadServerWorld() {
        if (serverManager == null) {
            serverManager = new RedstoneEtherServerAddons();
        }
    }

    public static void unloadServer() {
        serverManager = null;
    }

    public static void loadClientManager() {
        clientManager = new RedstoneEtherClientAddons();
    }

    public abstract void invalidateREP(EntityPlayer var1);

    public abstract boolean isRemoteOn(EntityPlayer var1, int var2);

    public abstract void activateRemote(World var1, EntityPlayer var2);

    public abstract boolean deactivateRemote(World var1, EntityPlayer var2);

    public static String localizeWirelessItem(String shortName, int freq) {
        if (freq <= 0 || freq > 5000 || RedstoneEther.client() == null) {
            return shortName;
        }
        String freqname = RedstoneEther.get(true).getFreqName(freq);
        if (freqname != null && !freqname.equals("")) {
            return freqname;
        }
        if (RedstoneEther.get(true).getFreqColourId(freq) == -1) {
            return shortName + ' ' + freq;
        }
        return RedstoneEther.get(true).getFreqColourName(freq, false) + ' ' + shortName + ' ' + freq;
    }

    static class AddonPlayerInfo {
        Remote remote;
        Sniffer sniffer;
        EntityREP activeREP;
        int REPThrowTimeout;
        WirelessMapNodeStorage mapNodes = new WirelessMapNodeStorage();
        HashSet<Integer> triangSet = new HashSet();
        HashSet<Integer> mapInfoSet = new HashSet();

        AddonPlayerInfo() {
        }
    }
}

