/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.EnumColor;
import mekanism.api.TileNetworkList;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.button.GuiButtonDisableableImage;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.client.gui.button.GuiReactorLogicButton;
import mekanism.generators.common.tile.reactor.TileEntityReactorLogicAdapter;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiReactorLogicAdapter
extends GuiMekanismTile<TileEntityReactorLogicAdapter> {
    private List<GuiReactorLogicButton> typeButtons = new ArrayList<GuiReactorLogicButton>();
    private GuiButton coolingButton;
    private int buttonID = 0;

    public GuiReactorLogicAdapter(InventoryPlayer inventory, TileEntityReactorLogicAdapter tile) {
        super((TileEntityContainerBlock)tile, (Container)new ContainerNull(inventory.field_70458_d, (TileEntityContainerBlock)tile));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.coolingButton = new GuiButtonDisableableImage(this.buttonID++, this.field_147003_i + 23, this.field_147009_r + 19, 11, 11, 176, 11, -11, this.getGuiLocation());
        this.field_146292_n.add(this.coolingButton);
        for (TileEntityReactorLogicAdapter.ReactorLogic type : TileEntityReactorLogicAdapter.ReactorLogic.values()) {
            int typeShift = 22 * type.ordinal();
            GuiReactorLogicButton button = new GuiReactorLogicButton(this.buttonID++, this.field_147003_i + 24, this.field_147009_r + 32 + typeShift, type, (TileEntityReactorLogicAdapter)this.tileEntity, this.getGuiLocation());
            this.field_146292_n.add(button);
            this.typeButtons.add(button);
        }
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == this.coolingButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer((IMessage)new PacketTileEntity.TileEntityMessage((TileEntity)this.tileEntity, TileNetworkList.withContents((Object[])new Object[]{0})));
        } else {
            for (GuiReactorLogicButton button : this.typeButtons) {
                if (guibutton.field_146127_k != button.field_146127_k) continue;
                Mekanism.packetHandler.sendToServer((IMessage)new PacketTileEntity.TileEntityMessage((TileEntity)this.tileEntity, TileNetworkList.withContents((Object[])new Object[]{1, button.getType().ordinal()})));
                break;
            }
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(((TileEntityReactorLogicAdapter)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityReactorLogicAdapter)this.tileEntity).func_70005_c_()) / 2, 6, 0x404040);
        this.renderScaledText(LangUtils.localize((String)"gui.coolingMeasurements") + ": " + EnumColor.RED + LangUtils.transOnOff((boolean)((TileEntityReactorLogicAdapter)this.tileEntity).activeCooled), 36, 20, 0x404040, 117);
        this.renderScaledText(LangUtils.localize((String)"gui.redstoneOutputMode") + ": " + EnumColor.RED + ((TileEntityReactorLogicAdapter)this.tileEntity).logicType.getLocalizedName(), 23, 123, 0x404040, 130);
        String text = LangUtils.localize((String)"gui.status") + ": " + EnumColor.RED + LangUtils.localize((String)("gui." + (((TileEntityReactorLogicAdapter)this.tileEntity).checkMode() ? "outputting" : "idle")));
        this.field_146289_q.func_78276_b(text, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(text) / 2, 136, 0x404040);
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        for (GuiReactorLogicButton button : this.typeButtons) {
            TileEntityReactorLogicAdapter.ReactorLogic type = button.getType();
            int typeOffset = 22 * type.ordinal();
            this.renderItem(type.getRenderStack(), 27, 35 + typeOffset);
            this.field_146289_q.func_78276_b(EnumColor.WHITE + type.getLocalizedName(), 46, 34 + typeOffset, 0x404040);
            if (!button.func_146115_a()) continue;
            this.displayTooltips(MekanismUtils.splitTooltip((String)type.getDescription(), (ItemStack)ItemStack.field_190927_a), xAxis, yAxis);
        }
        if (this.coolingButton.func_146115_a()) {
            this.displayTooltip(LangUtils.localize((String)"gui.toggleCooling"), xAxis, yAxis);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    protected ResourceLocation getGuiLocation() {
        return MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI, (String)"GuiReactorLogicAdapter.png");
    }
}

