/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.items.armor;

import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.api.itemconfig.ToolConfigHelper;
import com.brandon3055.draconicevolution.api.itemupgrade.UpgradeHelper;
import com.brandon3055.draconicevolution.lib.RecipeManager;
import java.util.List;
import javax.annotation.Nullable;
import net.foxmcloud.draconicadditions.DAConfig;
import net.foxmcloud.draconicadditions.DAFeatures;
import net.foxmcloud.draconicadditions.client.model.ModelPotatoArmor;
import net.foxmcloud.draconicadditions.items.armor.ArmorStats;
import net.foxmcloud.draconicadditions.items.armor.ChaoticArmor;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HermalArmor
extends ChaoticArmor {
    private static ItemArmor.ArmorMaterial hermalMaterial = EnumHelper.addArmorMaterial((String)"hermalArmor", (String)"draconicadditions:hermal_armor", (int)-1, (int[])new int[]{8, 14, 20, 8}, (int)0, (SoundEvent)SoundEvents.field_187728_s, (float)0.0f);
    @SideOnly(value=Side.CLIENT)
    public ModelBiped model;

    public HermalArmor(int renderIndexIn, EntityEquipmentSlot equipmentSlotIn) {
        super(hermalMaterial, renderIndexIn, equipmentSlotIn);
    }

    public HermalArmor(ItemArmor.ArmorMaterial materialIn, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn) {
        super(materialIn, renderIndexIn, equipmentSlotIn);
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (RecipeManager.isEnabled((Object)((Object)DAFeatures.hermal)) && this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((Item)this);
            this.setChaosStable(stack, true);
            this.modifyEnergy(stack, this.getCapacity(stack));
            subItems.add((Object)stack);
            if (this.getMaxUpgradeLevel(stack, "") > 0) {
                ItemStack uberStack = new ItemStack((Item)this);
                this.setChaosStable(uberStack, true);
                for (String upgrade : this.getValidUpgrades(uberStack)) {
                    UpgradeHelper.setUpgradeLevel((ItemStack)uberStack, (String)upgrade, (int)this.getMaxUpgradeLevel(uberStack, upgrade));
                }
                this.modifyEnergy(uberStack, this.getCapacity(uberStack));
                subItems.add((Object)uberStack);
            }
        }
    }

    @Override
    public int getMaxUpgradeLevel(ItemStack stack, String upgrade) {
        return ArmorStats.HERMAL_UPGRADE_LEVEL;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (ToolConfigHelper.getBooleanField((String)"hideArmor", (ItemStack)itemStack)) {
            if (this.model_invisible == null) {
                this.model_invisible = new ModelBiped(){

                    public void func_78088_a(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
                    }
                };
            }
            return this.model_invisible;
        }
        if (DEConfig.disable3DModels) {
            return super.getArmorModel(entityLiving, itemStack, armorSlot, _default);
        }
        if (this.model == null) {
            this.model = this.field_77881_a == EntityEquipmentSlot.HEAD ? new ModelPotatoArmor(0.5f, true, false, false, false) : (this.field_77881_a == EntityEquipmentSlot.CHEST ? new ModelPotatoArmor(1.5f, false, true, false, false) : (this.field_77881_a == EntityEquipmentSlot.LEGS ? new ModelPotatoArmor(1.5f, false, false, true, false) : new ModelPotatoArmor(1.0f, false, false, false, true)));
            this.model.field_78116_c.field_78806_j = this.field_77881_a == EntityEquipmentSlot.HEAD;
            this.model.field_178720_f.field_78806_j = this.field_77881_a == EntityEquipmentSlot.HEAD;
            this.model.field_78115_e.field_78806_j = this.field_77881_a == EntityEquipmentSlot.CHEST || this.field_77881_a == EntityEquipmentSlot.LEGS;
            this.model.field_178724_i.field_78806_j = this.field_77881_a == EntityEquipmentSlot.CHEST;
            this.model.field_178723_h.field_78806_j = this.field_77881_a == EntityEquipmentSlot.CHEST;
            this.model.field_178722_k.field_78806_j = this.field_77881_a == EntityEquipmentSlot.LEGS || this.field_77881_a == EntityEquipmentSlot.FEET;
            boolean bl = this.model.field_178721_j.field_78806_j = this.field_77881_a == EntityEquipmentSlot.LEGS || this.field_77881_a == EntityEquipmentSlot.FEET;
        }
        if (entityLiving == null) {
            return this.model;
        }
        this.model.field_78117_n = entityLiving.func_70093_af();
        this.model.field_78093_q = entityLiving.func_184218_aH();
        this.model.field_78091_s = entityLiving.func_70631_g_();
        this.model.field_178720_f.field_78806_j = this.field_77881_a == EntityEquipmentSlot.HEAD;
        this.model.field_78115_e.field_78806_j = this.field_77881_a == EntityEquipmentSlot.CHEST || this.field_77881_a == EntityEquipmentSlot.LEGS;
        this.model.field_178724_i.field_78806_j = this.field_77881_a == EntityEquipmentSlot.CHEST;
        this.model.field_178723_h.field_78806_j = this.field_77881_a == EntityEquipmentSlot.CHEST;
        this.model.field_178722_k.field_78806_j = this.field_77881_a == EntityEquipmentSlot.LEGS || this.field_77881_a == EntityEquipmentSlot.FEET;
        this.model.field_178721_j.field_78806_j = this.field_77881_a == EntityEquipmentSlot.LEGS || this.field_77881_a == EntityEquipmentSlot.FEET;
        return this.model;
    }

    @Override
    public float getProtectionPoints(ItemStack stack) {
        float points = (float)ArmorStats.HERMAL_BASE_SHIELD_CAPACITY * this.getProtectionShare();
        return points;
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (!stack.func_190926_b()) {
            if (!this.isChaosStable(stack)) {
                this.setChaosStable(stack, true);
            }
            HermalArmor armor = (HermalArmor)stack.func_77973_b();
            armor.modifyEnergy(stack, DAConfig.HERMAL_RF);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.func_135052_a((String)"item.draconicadditions:hermal.lore", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"item.draconicadditions:hermal.lore2", (Object[])new Object[0]));
        super.func_77624_a(stack, playerIn, tooltip, advanced);
    }

    @Override
    public float getRecoveryRate(ItemStack stack) {
        return (float)ArmorStats.HERMAL_SHIELD_RECOVERY;
    }

    @Override
    public int getEnergyPerProtectionPoint() {
        return ArmorStats.HERMAL_SHIELD_RECHARGE_COST;
    }

    @Override
    protected int getCapacity(ItemStack stack) {
        return ArmorStats.HERMAL_BASE_CAPACITY;
    }

    @Override
    protected int getMaxReceive(ItemStack stack) {
        return ArmorStats.HERMAL_MAX_RECIEVE;
    }
}

