/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.client.render.tile;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.OBJParser;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.render.shader.ShaderProgram;
import codechicken.lib.render.state.GlStateTracker;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.client.render.TESRBase;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.client.render.shaders.DEShaders;
import com.brandon3055.draconicevolution.helpers.ResourceHelperDE;
import java.util.Map;
import net.foxmcloud.draconicadditions.blocks.chaosritual.tileentity.TileChaosStabilizerCore;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;

public class RenderTileChaosStabilizerCore
extends TESRBase<TileChaosStabilizerCore> {
    private static CCModel model = null;
    private static CCModel model_no_shade;
    private static ShaderProgram reactorProgram;

    public RenderTileChaosStabilizerCore() {
        if (model == null) {
            Map map = OBJParser.parseModels((ResourceLocation)ResourceHelperDE.getResource((String)"models/block/obj_models/reactor_core.obj"));
            model = CCModel.combine(map.values());
            map = OBJParser.parseModels((ResourceLocation)ResourceHelperDE.getResource((String)"models/reactor_core_model.obj"));
            model_no_shade = CCModel.combine(map.values());
        }
    }

    public void render(TileChaosStabilizerCore te, double x, double y, double z, float partialTicks, int destroyStage, float a) {
        double intensity;
        GlStateManager.func_179094_E();
        GlStateTracker.pushState();
        GlStateManager.func_179140_f();
        this.setLighting(100.0f);
        double diameter = te.getCoreDiameter();
        double t = te.getCoreIntensity();
        double d = t <= 0.2 ? Utils.map((double)t, (double)0.0, (double)0.2, (double)0.0, (double)0.3) : (intensity = t <= 0.8 ? Utils.map((double)t, (double)0.2, (double)0.8, (double)0.3, (double)1.0) : Utils.map((double)t, (double)0.8, (double)1.0, (double)1.0, (double)1.3));
        if (MinecraftForgeClient.getRenderPass() == 0) {
            float animation = partialTicks / 10.0f;
            RenderTileChaosStabilizerCore.renderCore(x, y, z, partialTicks, (float)intensity, animation, diameter, DEShaders.useShaders());
        }
        this.resetLighting();
        GlStateTracker.popState();
        GlStateManager.func_179121_F();
    }

    public void renderItem() {
        GlStateManager.func_179094_E();
        GlStateTracker.pushState();
        GlStateManager.func_179140_f();
        this.setLighting(100.0f);
        float scale = 1.3f;
        float animation = 0.0f;
        float intensity = 0.25f;
        RenderTileChaosStabilizerCore.renderCore(0.0, 0.0, 0.0, 0.0f, intensity, animation, scale, DEShaders.useShaders());
        this.resetLighting();
        GlStateTracker.popState();
        GlStateManager.func_179121_F();
    }

    private static void renderCore(double x, double y, double z, float partialTicks, float intensity, float animation, double diameter, boolean useShader) {
        ResourceHelperDE.bindTexture((String)"textures/models/reactor_core.png");
        if (useShader) {
            if (reactorProgram == null) {
                reactorProgram = new ShaderProgram();
                reactorProgram.attachShader(DEShaders.reactor);
            }
            reactorProgram.useShader(cache -> {
                cache.glUniform1F("time", animation);
                cache.glUniform1F("intensity", intensity);
            });
        }
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.startDrawing(4, DefaultVertexFormats.field_181707_g);
        Matrix4 mat = RenderUtils.getMatrix((Vector3)new Vector3(x + 0.5, y + 0.5, z + 0.5), (Rotation)new Rotation((double)(((float)ClientEventHandler.elapsedTicks + partialTicks) / 400.0f), 0.0, 1.0, 0.0), (double)diameter);
        model.render(ccrs, new IVertexOperation[]{mat});
        ccrs.draw();
        if (useShader) {
            reactorProgram.releaseShader();
        }
    }

    public boolean isGlobalRenderer(TileChaosStabilizerCore te) {
        return true;
    }
}

